/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.basic;

import com.thoughtworks.xstream.converters.ConditionalConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class BooleanConverter
implements Converter,
ConditionalConverter {
    public static final BooleanConverter TRUE_FALSE = new BooleanConverter("true", "false", false);
    public static final BooleanConverter YES_NO = new BooleanConverter("yes", "no", false);
    public static final BooleanConverter BINARY = new BooleanConverter("1", "0", true);
    public static final BooleanConverter EMPTY_ELEMENT = new BooleanConverter(){

        public boolean shouldConvert(Class type, Object obj) {
            Boolean value = (Boolean)obj;
            return value;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return Boolean.TRUE;
        }
    };
    private final String positive;
    private final String negative;
    private final boolean caseSensitive;
    static /* synthetic */ Class class$java$lang$Boolean;

    public BooleanConverter(String positive, String negative, boolean caseSensitive) {
        this.positive = positive;
        this.negative = negative;
        this.caseSensitive = caseSensitive;
    }

    public BooleanConverter() {
        this("true", "false", false);
    }

    public boolean shouldConvert(Class type, Object value) {
        return true;
    }

    public boolean canConvert(Class type) {
        return type.equals(Boolean.TYPE) || type.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Boolean value = (Boolean)source;
        writer.setValue(value != false ? this.positive : this.negative);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (this.caseSensitive) {
            return this.positive.equals(reader.getValue()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.positive.equalsIgnoreCase(reader.getValue()) ? Boolean.TRUE : Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

