/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.parse;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.MatchMaker;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.parse.EvilManualUseragentStringHacks;
import nl.basjes.parse.useragent.parser.UserAgentBaseListener;
import nl.basjes.parse.useragent.parser.UserAgentLexer;
import nl.basjes.parse.useragent.parser.UserAgentParser;
import nl.basjes.parse.useragent.utils.AntlrUtils;
import nl.basjes.parse.useragent.utils.Splitter;
import nl.basjes.parse.useragent.utils.VersionSplitter;
import nl.basjes.parse.useragent.utils.WordSplitter;
import nl.basjes.shaded.org.antlr.v4.runtime.CharStreams;
import nl.basjes.shaded.org.antlr.v4.runtime.CodePointCharStream;
import nl.basjes.shaded.org.antlr.v4.runtime.CommonTokenStream;
import nl.basjes.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTreeProperty;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.lang3.tuple.Pair;

public class UserAgentTreeFlattener
extends UserAgentBaseListener
implements Serializable {
    private final MatchMaker analyzer;
    private static final String AGENT = "agent";
    private static final String PRODUCT = "product";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String COMMENTS = "comments";
    private static final String KEYVALUE = "keyvalue";
    private static final String KEY = "key";
    private static final String TEXT = "text";
    private static final String URL = "url";
    private static final String UUID = "uuid";
    private static final String EMAIL = "email";
    private static final String BASE64 = "base64";
    private transient ParseTreeProperty<State> state;
    private boolean verbose = false;

    private UserAgentTreeFlattener() {
        this.analyzer = new MatchMaker.Dummy();
    }

    public UserAgentTreeFlattener(MatchMaker analyzer) {
        this.analyzer = analyzer;
    }

    public void clear() {
        this.state = null;
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
    }

    public UserAgent parse(String userAgentString) {
        UserAgent.MutableUserAgent userAgent = new UserAgent.MutableUserAgent(userAgentString);
        return this.parseIntoCleanUserAgent(userAgent);
    }

    public UserAgent.MutableUserAgent parse(UserAgent.MutableUserAgent userAgent) {
        userAgent.reset();
        return this.parseIntoCleanUserAgent(userAgent);
    }

    private UserAgent.MutableUserAgent parseIntoCleanUserAgent(UserAgent.MutableUserAgent userAgent) {
        if (userAgent.getUserAgentString() == null) {
            userAgent.set("__SyntaxError__", "true", 1L);
            return userAgent;
        }
        UserAgentParser.UserAgentContext userAgentContext = this.parseUserAgent(userAgent);
        this.state = new ParseTreeProperty();
        State rootState = new State(AGENT);
        rootState.calculatePath(PathType.CHILD, false);
        this.state.put(userAgentContext, rootState);
        if (userAgent.hasSyntaxError()) {
            this.inform(null, "__SyntaxError__", "true");
        } else {
            this.inform(null, "__SyntaxError__", "false");
        }
        ParseTreeWalker.DEFAULT.walk(this, userAgentContext);
        return userAgent;
    }

    private String inform(ParseTree ctx, String path) {
        return this.inform(ctx, path, AntlrUtils.getSourceText((ParserRuleContext)ctx));
    }

    private String inform(ParseTree ctx, String name, String value) {
        return this.inform(ctx, ctx, name, value, false);
    }

    private String inform(ParseTree ctx, String name, String value, boolean fakeChild) {
        return this.inform(ctx, ctx, name, value, fakeChild);
    }

    private String inform(ParseTree stateCtx, ParseTree ctx, String name, String value, boolean fakeChild) {
        String path = name;
        if (stateCtx != null) {
            PathType childType;
            State myState = new State(stateCtx, name);
            if (!fakeChild) {
                this.state.put(stateCtx, myState);
            }
            switch (name) {
                case "comments": {
                    childType = PathType.COMMENT;
                    break;
                }
                case "version": {
                    childType = PathType.VERSION;
                    break;
                }
                default: {
                    childType = PathType.CHILD;
                }
            }
            path = myState.calculatePath(childType, fakeChild);
        }
        this.analyzer.inform(path, value, ctx);
        return path;
    }

    private UserAgentParser.UserAgentContext parseUserAgent(UserAgent.MutableUserAgent userAgent) {
        String userAgentString = EvilManualUseragentStringHacks.fixIt(userAgent.getUserAgentString());
        CodePointCharStream input = CharStreams.fromString(userAgentString);
        UserAgentLexer lexer = new UserAgentLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        UserAgentParser parser = new UserAgentParser(tokens);
        if (!this.verbose) {
            lexer.removeErrorListeners();
            parser.removeErrorListeners();
        }
        lexer.addErrorListener(userAgent);
        parser.addErrorListener(userAgent);
        return parser.userAgent();
    }

    @Override
    public void enterUserAgent(UserAgentParser.UserAgentContext ctx) {
        this.inform(ctx, AGENT, ctx.start.getTokenSource().getInputStream().toString());
    }

    @Override
    public void enterRootText(UserAgentParser.RootTextContext ctx) {
        this.informSubstrings(ctx, TEXT);
    }

    @Override
    public void enterProduct(UserAgentParser.ProductContext ctx) {
        this.informSubstrings(ctx, PRODUCT);
    }

    @Override
    public void enterCommentProduct(UserAgentParser.CommentProductContext ctx) {
        this.informSubstrings(ctx, PRODUCT);
    }

    @Override
    public void enterProductNameNoVersion(UserAgentParser.ProductNameNoVersionContext ctx) {
        this.informSubstrings(ctx, PRODUCT);
    }

    @Override
    public void enterProductNameEmail(UserAgentParser.ProductNameEmailContext ctx) {
        this.inform(ctx, NAME);
    }

    @Override
    public void enterProductNameUrl(UserAgentParser.ProductNameUrlContext ctx) {
        this.inform(ctx, NAME);
    }

    @Override
    public void enterProductNameWords(UserAgentParser.ProductNameWordsContext ctx) {
        this.informSubstrings(ctx, NAME);
    }

    @Override
    public void enterProductNameKeyValue(UserAgentParser.ProductNameKeyValueContext ctx) {
        this.inform(ctx, "name.(1)keyvalue", ctx.getText(), false);
        this.informSubstrings(ctx, NAME, true);
    }

    @Override
    public void enterProductNameVersion(UserAgentParser.ProductNameVersionContext ctx) {
        this.informSubstrings(ctx, NAME);
    }

    @Override
    public void enterProductNameUuid(UserAgentParser.ProductNameUuidContext ctx) {
        this.inform(ctx, NAME);
    }

    @Override
    public void enterProductVersion(UserAgentParser.ProductVersionContext ctx) {
        this.enterProductVersion((ParseTree)ctx);
    }

    @Override
    public void enterProductVersionWithCommas(UserAgentParser.ProductVersionWithCommasContext ctx) {
        this.enterProductVersion(ctx);
    }

    private void enterProductVersion(ParseTree ctx) {
        ParseTree child = ctx.getChild(0);
        if (child instanceof UserAgentParser.SingleVersionContext || child instanceof UserAgentParser.SingleVersionWithCommasContext) {
            return;
        }
        this.inform(ctx, VERSION);
    }

    @Override
    public void enterProductVersionSingleWord(UserAgentParser.ProductVersionSingleWordContext ctx) {
        this.inform(ctx, VERSION);
    }

    @Override
    public void enterSingleVersion(UserAgentParser.SingleVersionContext ctx) {
        this.informSubVersions(ctx);
    }

    @Override
    public void enterSingleVersionWithCommas(UserAgentParser.SingleVersionWithCommasContext ctx) {
        this.informSubVersions(ctx);
    }

    @Override
    public void enterProductVersionWords(UserAgentParser.ProductVersionWordsContext ctx) {
        this.informSubstrings(ctx, VERSION);
    }

    @Override
    public void enterKeyValueProductVersionName(UserAgentParser.KeyValueProductVersionNameContext ctx) {
        this.informSubstrings(ctx, VERSION);
    }

    @Override
    public void enterCommentBlock(UserAgentParser.CommentBlockContext ctx) {
        this.inform(ctx, COMMENTS);
    }

    @Override
    public void enterCommentEntry(UserAgentParser.CommentEntryContext ctx) {
        this.informSubstrings(ctx, "entry");
    }

    private void informSubstrings(ParserRuleContext ctx, String name) {
        this.informSubstrings(ctx, name, false);
    }

    private void informSubstrings(ParserRuleContext ctx, String name, boolean fakeChild) {
        this.informSubstrings(ctx, name, fakeChild, WordSplitter.getInstance());
    }

    private void informSubVersions(ParserRuleContext ctx) {
        this.informSubstrings(ctx, VERSION, false, VersionSplitter.getInstance());
    }

    private void informSubstrings(ParserRuleContext ctx, String name, boolean fakeChild, Splitter splitter) {
        String text = AntlrUtils.getSourceText(ctx);
        String path = this.inform(ctx, name, text, fakeChild);
        Set<WordRangeVisitor.Range> ranges = this.analyzer.getRequiredInformRanges(path);
        if (ranges.size() > 4) {
            List<Pair<Integer, Integer>> splitList = splitter.createSplitList(text);
            for (WordRangeVisitor.Range range : ranges) {
                String value = splitter.getSplitRange(text, splitList, range);
                if (value == null) continue;
                this.inform(ctx, ctx, name + range, value, true);
            }
        } else {
            for (WordRangeVisitor.Range range : ranges) {
                String value = splitter.getSplitRange(text, range);
                if (value == null) continue;
                this.inform(ctx, ctx, name + range, value, true);
            }
        }
    }

    @Override
    public void enterMultipleWords(UserAgentParser.MultipleWordsContext ctx) {
        this.informSubstrings(ctx, TEXT);
    }

    @Override
    public void enterKeyValue(UserAgentParser.KeyValueContext ctx) {
        this.inform(ctx, KEYVALUE);
    }

    @Override
    public void enterKeyWithoutValue(UserAgentParser.KeyWithoutValueContext ctx) {
        this.inform(ctx, KEYVALUE);
    }

    @Override
    public void enterKeyName(UserAgentParser.KeyNameContext ctx) {
        this.informSubstrings(ctx, KEY);
    }

    @Override
    public void enterKeyValueVersionName(UserAgentParser.KeyValueVersionNameContext ctx) {
        this.informSubstrings(ctx, VERSION);
    }

    @Override
    public void enterVersionWords(UserAgentParser.VersionWordsContext ctx) {
        this.informSubstrings(ctx, TEXT);
    }

    @Override
    public void enterSiteUrl(UserAgentParser.SiteUrlContext ctx) {
        this.inform(ctx, URL, ctx.url.getText());
    }

    @Override
    public void enterUuId(UserAgentParser.UuIdContext ctx) {
        this.inform(ctx, UUID, ctx.uuid.getText());
    }

    @Override
    public void enterEmailAddress(UserAgentParser.EmailAddressContext ctx) {
        this.inform(ctx, EMAIL, ctx.email.getText());
    }

    @Override
    public void enterBase64(UserAgentParser.Base64Context ctx) {
        this.inform(ctx, BASE64, ctx.value.getText());
    }

    @Override
    public void enterEmptyWord(UserAgentParser.EmptyWordContext ctx) {
        this.inform(ctx, TEXT, "");
    }

    public String toString() {
        return "UserAgentTreeFlattener{ verbose=" + this.verbose + "} ";
    }

    public class State {
        long child = 0L;
        long version = 0L;
        long comment = 0L;
        final String name;
        String path;
        ParseTree ctx = null;

        private State() {
            this.name = null;
        }

        public State(String name) {
            this.name = name;
        }

        public State(ParseTree ctx, String name) {
            this.ctx = ctx;
            this.name = name;
        }

        public String calculatePath(PathType type, boolean fakeChild) {
            ParseTree node = this.ctx;
            this.path = this.name;
            if (node == null) {
                return this.path;
            }
            State parentState = null;
            while (parentState == null) {
                if ((node = node.getParent()) == null) {
                    return this.path;
                }
                parentState = (State)UserAgentTreeFlattener.this.state.get(node);
            }
            long counter = 0L;
            switch (type) {
                case CHILD: {
                    if (!fakeChild) {
                        ++parentState.child;
                    }
                    counter = parentState.child;
                    break;
                }
                case COMMENT: {
                    if (!fakeChild) {
                        ++parentState.comment;
                    }
                    counter = parentState.comment;
                    break;
                }
                case VERSION: {
                    if (!fakeChild) {
                        ++parentState.version;
                    }
                    counter = parentState.version;
                    break;
                }
            }
            this.path = parentState.path + ".(" + counter + ')' + this.name;
            return this.path;
        }
    }

    static enum PathType {
        CHILD,
        COMMENT,
        VERSION;

    }
}

