/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.ArrayList;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.functions.IndicesFunction;

@BuiltinFunction(value={"index/1"})
public class IndexFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode needle : args.get(0).apply(scope, in)) {
            List<Integer> tmp = IndicesFunction.indices(needle, in);
            if (tmp.isEmpty()) {
                out.add((JsonNode)NullNode.getInstance());
                continue;
            }
            out.add((JsonNode)new IntNode(tmp.get(0).intValue()));
        }
        return out;
    }
}

