/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RecursiveFilesIterator
implements Iterator<File> {
    public static final FileFilter ANY_READABLE_FILE = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isFile() && f.canRead();
        }
    };
    public static final FileFilter CLASS_FILE = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return ANY_READABLE_FILE.accept(f) && f.getName().endsWith(".class");
        }
    };
    private static final FileFilter DIRECTORY = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isDirectory() && f.canRead();
        }
    };
    private final File rootDir;
    private final FileFilter fileFilter;
    private boolean usedFiles = false;
    private boolean usedDirs = false;
    private Iterator<File> currentDelegate;
    private Iterator<File> currentDirs;

    public static Iterable<File> scanClassFiles(File rootDir) {
        return RecursiveFilesIterator.scanFiles(rootDir, CLASS_FILE);
    }

    public static Iterable<File> scanFiles(final File rootDir, final FileFilter fileFilter) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new RecursiveFilesIterator(rootDir, fileFilter);
            }
        };
    }

    public RecursiveFilesIterator(File rootDir, FileFilter fileFilter) {
        if (null == rootDir) {
            throw new IllegalArgumentException("Directory parameter may not be null");
        }
        if (!DIRECTORY.accept(rootDir)) {
            throw new IllegalArgumentException(rootDir + " is not an existing readable directory");
        }
        this.rootDir = rootDir;
        this.fileFilter = fileFilter;
    }

    protected void setupDelegate() {
        if (!this.usedFiles) {
            this.usedFiles = true;
            File[] files = this.rootDir.listFiles(this.fileFilter);
            this.currentDelegate = files != null && files.length > 0 ? Arrays.asList(files).iterator() : Collections.emptySet().iterator();
        }
        if (!this.currentDelegate.hasNext()) {
            if (!this.usedDirs) {
                this.usedDirs = true;
                File[] dirs = this.rootDir.listFiles(DIRECTORY);
                this.currentDirs = dirs != null && dirs.length > 0 ? Arrays.asList(dirs).iterator() : Collections.emptySet().iterator();
            }
            while (!this.currentDelegate.hasNext() && this.currentDirs.hasNext()) {
                this.currentDelegate = new RecursiveFilesIterator(this.currentDirs.next(), this.fileFilter);
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.setupDelegate();
        return null != this.currentDelegate && this.currentDelegate.hasNext();
    }

    @Override
    public File next() {
        this.setupDelegate();
        if (null != this.currentDelegate) {
            return this.currentDelegate.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

