/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.javaflow.spi.AbstractResourceTransformer;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.apache.commons.javaflow.spi.ResourceTransformationFactory;
import org.apache.commons.javaflow.spi.ResourceTransformer;

public class CompositeResourceTransformer
extends AbstractResourceTransformer {
    private final List<? extends ResourceTransformer> transformers;

    public CompositeResourceTransformer(ResourceTransformer[] transformers) {
        this(Arrays.asList(transformers), false);
    }

    public CompositeResourceTransformer(List<? extends ResourceTransformer> transformers) {
        this(transformers, true);
    }

    private CompositeResourceTransformer(List<? extends ResourceTransformer> transformers, boolean makeCopy) {
        this.transformers = makeCopy ? CompositeResourceTransformer.makeCopy(transformers) : transformers;
    }

    @Override
    public byte[] transform(byte[] image, Collection<String> retransformClasses) {
        for (ResourceTransformer resourceTransformer : this.transformers) {
            byte[] result = resourceTransformer.transform(image, retransformClasses);
            if (null == result) continue;
            image = result;
        }
        return image;
    }

    @Override
    public void release() {
        for (ResourceTransformer resourceTransformer : this.transformers) {
            resourceTransformer.release();
        }
    }

    public static ResourceTransformationFactory composeFactories(ResourceTransformationFactory ... factories) {
        return CompositeResourceTransformer.composeFactories(Arrays.asList(factories), false);
    }

    public static ResourceTransformationFactory composeFactories(List<? extends ResourceTransformationFactory> factories) {
        return CompositeResourceTransformer.composeFactories(factories, true);
    }

    private static ResourceTransformationFactory composeFactories(List<? extends ResourceTransformationFactory> originalFactories, boolean makeCopy) {
        final List<? extends ResourceTransformationFactory> factories = makeCopy ? CompositeResourceTransformer.makeCopy(originalFactories) : originalFactories;
        return new ResourceTransformationFactory(){

            @Override
            public ResourceTransformer createTransformer(ResourceLoader resourceLoader) {
                ResourceTransformer[] transformers = new ResourceTransformer[factories.size()];
                int idx = 0;
                for (ResourceTransformationFactory factory : factories) {
                    transformers[idx++] = factory.createTransformer(resourceLoader);
                }
                return new CompositeResourceTransformer(transformers);
            }
        };
    }

    private static <T> List<T> makeCopy(List<? extends T> original) {
        return new ArrayList<T>(original);
    }
}

