/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

class ClassHeaderReader {
    private final byte[] b;
    private final int[] cpInfoOffsets;
    private final String[] constantUtf8Values;
    private final int maxStringLength;
    private final int header;

    ClassHeaderReader(byte[] classFile) {
        this(classFile, 0);
    }

    private ClassHeaderReader(byte[] classFileBuffer, int classFileOffset) {
        this.b = classFileBuffer;
        int constantPoolCount = this.readUnsignedShort(classFileOffset + 8);
        this.cpInfoOffsets = new int[constantPoolCount];
        this.constantUtf8Values = new String[constantPoolCount];
        int currentCpInfoIndex = 1;
        int currentCpInfoOffset = classFileOffset + 10;
        int currentMaxStringLength = 0;
        boolean hasConstantDynamic = false;
        boolean hasBootstrapMethods = false;
        while (currentCpInfoIndex < constantPoolCount) {
            int cpInfoSize;
            this.cpInfoOffsets[currentCpInfoIndex++] = currentCpInfoOffset + 1;
            switch (classFileBuffer[currentCpInfoOffset]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    cpInfoSize = 5;
                    break;
                }
                case 17: {
                    cpInfoSize = 5;
                    hasBootstrapMethods = true;
                    hasConstantDynamic = true;
                    break;
                }
                case 18: {
                    cpInfoSize = 5;
                    hasBootstrapMethods = true;
                    break;
                }
                case 5: 
                case 6: {
                    cpInfoSize = 9;
                    ++currentCpInfoIndex;
                    break;
                }
                case 1: {
                    cpInfoSize = 3 + this.readUnsignedShort(currentCpInfoOffset + 1);
                    if (cpInfoSize <= currentMaxStringLength) break;
                    currentMaxStringLength = cpInfoSize;
                    break;
                }
                case 15: {
                    cpInfoSize = 4;
                    break;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    cpInfoSize = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            currentCpInfoOffset += cpInfoSize;
        }
        this.maxStringLength = currentMaxStringLength;
        this.header = currentCpInfoOffset;
    }

    String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    String getSuperName() {
        return this.readClass(this.header + 4, new char[this.maxStringLength]);
    }

    String[] getInterfaces() {
        int currentOffset = this.header + 6;
        int interfacesCount = this.readUnsignedShort(currentOffset);
        String[] interfaces = new String[interfacesCount];
        if (interfacesCount > 0) {
            char[] charBuffer = new char[this.maxStringLength];
            for (int i = 0; i < interfacesCount; ++i) {
                interfaces[i] = this.readClass(currentOffset += 2, charBuffer);
            }
        }
        return interfaces;
    }

    private int readUnsignedShort(int offset) {
        byte[] classFileBuffer = this.b;
        return (classFileBuffer[offset] & 0xFF) << 8 | classFileBuffer[offset + 1] & 0xFF;
    }

    private short readShort(int offset) {
        byte[] classFileBuffer = this.b;
        return (short)((classFileBuffer[offset] & 0xFF) << 8 | classFileBuffer[offset + 1] & 0xFF);
    }

    private String readUTF8(int offset, char[] charBuffer) {
        int constantPoolEntryIndex = this.readUnsignedShort(offset);
        if (offset == 0 || constantPoolEntryIndex == 0) {
            return null;
        }
        return this.readUtf(constantPoolEntryIndex, charBuffer);
    }

    private final String readUtf(int constantPoolEntryIndex, char[] charBuffer) {
        String value = this.constantUtf8Values[constantPoolEntryIndex];
        if (value != null) {
            return value;
        }
        int cpInfoOffset = this.cpInfoOffsets[constantPoolEntryIndex];
        this.constantUtf8Values[constantPoolEntryIndex] = this.readUtf(cpInfoOffset + 2, this.readUnsignedShort(cpInfoOffset), charBuffer);
        return this.constantUtf8Values[constantPoolEntryIndex];
    }

    private String readUtf(int utfOffset, int utfLength, char[] charBuffer) {
        int currentOffset = utfOffset;
        int endOffset = currentOffset + utfLength;
        int strLength = 0;
        byte[] classFileBuffer = this.b;
        while (currentOffset < endOffset) {
            byte currentByte;
            if (((currentByte = classFileBuffer[currentOffset++]) & 0x80) == 0) {
                charBuffer[strLength++] = (char)(currentByte & 0x7F);
                continue;
            }
            if ((currentByte & 0xE0) == 192) {
                charBuffer[strLength++] = (char)(((currentByte & 0x1F) << 6) + (classFileBuffer[currentOffset++] & 0x3F));
                continue;
            }
            charBuffer[strLength++] = (char)(((currentByte & 0xF) << 12) + ((classFileBuffer[currentOffset++] & 0x3F) << 6) + (classFileBuffer[currentOffset++] & 0x3F));
        }
        return new String(charBuffer, 0, strLength);
    }

    private String readStringish(int offset, char[] charBuffer) {
        return this.readUTF8(this.cpInfoOffsets[this.readUnsignedShort(offset)], charBuffer);
    }

    private String readClass(int offset, char[] charBuffer) {
        return this.readStringish(offset, charBuffer);
    }

    private static class Symbol {
        static final int CONSTANT_CLASS_TAG = 7;
        static final int CONSTANT_FIELDREF_TAG = 9;
        static final int CONSTANT_METHODREF_TAG = 10;
        static final int CONSTANT_INTERFACE_METHODREF_TAG = 11;
        static final int CONSTANT_STRING_TAG = 8;
        static final int CONSTANT_INTEGER_TAG = 3;
        static final int CONSTANT_FLOAT_TAG = 4;
        static final int CONSTANT_LONG_TAG = 5;
        static final int CONSTANT_DOUBLE_TAG = 6;
        static final int CONSTANT_NAME_AND_TYPE_TAG = 12;
        static final int CONSTANT_UTF8_TAG = 1;
        static final int CONSTANT_METHOD_HANDLE_TAG = 15;
        static final int CONSTANT_METHOD_TYPE_TAG = 16;
        static final int CONSTANT_DYNAMIC_TAG = 17;
        static final int CONSTANT_INVOKE_DYNAMIC_TAG = 18;
        static final int CONSTANT_MODULE_TAG = 19;
        static final int CONSTANT_PACKAGE_TAG = 20;

        private Symbol() {
        }
    }
}

