/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.javaflow.spi.ClassMatcher;
import org.apache.commons.javaflow.spi.ClassMatchers;
import org.apache.commons.javaflow.spi.FastByteArrayInputStream;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.apache.commons.javaflow.spi.VetoableResourceLoader;

public class MorphingResourceLoader
implements VetoableResourceLoader {
    protected final ResourceLoader delegate;
    private final Map<String, byte[]> extraResources;

    public MorphingResourceLoader(ResourceLoader delegate) {
        this(delegate, Collections.emptyMap());
    }

    public MorphingResourceLoader(ResourceLoader delegate, Map<String, byte[]> extraResources) {
        this.delegate = delegate;
        this.extraResources = null != extraResources ? Collections.unmodifiableMap(extraResources) : Collections.emptyMap();
    }

    public final ResourceLoader withReplacement(String altResourceName, byte[] altResourceContent) {
        return this.withReplacement(Collections.singletonMap(altResourceName, altResourceContent));
    }

    public ResourceLoader withReplacement(Map<String, byte[]> alternativeResources) {
        return new MorphingResourceLoader(this.delegate, alternativeResources);
    }

    public final ResourceLoader withAddition(String addResourceName, byte[] addResourceContent) {
        return this.withAddition(Collections.singletonMap(addResourceName, addResourceContent));
    }

    public ResourceLoader withAddition(Map<String, byte[]> additionalResources) {
        return new MorphingResourceLoader(this, additionalResources);
    }

    @Override
    public boolean hasResource(String name) {
        return this.extraResources.containsKey(name) || this.delegate.hasResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) throws IOException {
        byte[] result = this.extraResources.get(name);
        if (null != result) {
            return new FastByteArrayInputStream(result);
        }
        return this.delegate.getResourceAsStream(name);
    }

    @Override
    public ClassMatcher createVeto() throws IOException {
        if (this.delegate instanceof VetoableResourceLoader) {
            return ((VetoableResourceLoader)this.delegate).createVeto();
        }
        return ClassMatchers.MATCH_NONE;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (null == other || other.getClass() != this.getClass()) {
            return false;
        }
        return this.delegate.equals(((MorphingResourceLoader)other).delegate);
    }
}

