/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.javaflow.providers.asm5.ContinuableClassInfoInternal;
import org.apache.commons.javaflow.providers.asm5.MaybeContinuableAnnotationVisitor;
import org.apache.commons.javaflow.providers.asm5.MaybeContinuableClassVisitor;
import org.apache.commons.javaflow.spi.ContinuableClassInfo;
import org.apache.commons.javaflow.spi.ContinuableClassInfoResolver;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

class Asm5ContinuableClassInfoResolver
implements ContinuableClassInfoResolver {
    private final Map<String, ContinuableClassInfo> visitedClasses = new HashMap<String, ContinuableClassInfo>();
    private final Set<String> processedAnnotations = new HashSet<String>();
    private final Set<String> continuableAnnotations = new HashSet<String>();
    private final ResourceLoader resourceLoader;
    private static final Type CONTINUABLE_ANNOTATION_TYPE = Type.getObjectType((String)"org/apache/commons/javaflow/api/ContinuableAnnotation");
    private static final ContinuableClassInfo UNSUPPORTED_CLASS_INFO = new ContinuableClassInfo(){

        public void markClassProcessed() {
        }

        public boolean isContinuableMethod(int access, String name, String desc, String signature) {
            return false;
        }

        public boolean isClassProcessed() {
            return true;
        }
    };

    Asm5ContinuableClassInfoResolver(ResourceLoader classLoader) {
        this.resourceLoader = classLoader;
        this.markContinuableAnnotation(CONTINUABLE_ANNOTATION_TYPE.getDescriptor());
    }

    public ResourceLoader resourceLoader() {
        return this.resourceLoader;
    }

    public ContinuableClassInfo forget(String className) {
        return this.visitedClasses.remove(className);
    }

    public ContinuableClassInfo resolve(String classInternalName, byte[] classBytes) {
        return this.resolveContinuableClassInfo(classInternalName, new ClassReader(classBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinuableClassInfo resolve(String classInternalName) throws IOException {
        InputStream classBytes = this.resourceLoader.getResourceAsStream(classInternalName + ".class");
        try {
            ContinuableClassInfo continuableClassInfo = this.resolveContinuableClassInfo(classInternalName, new ClassReader(classBytes));
            return continuableClassInfo;
        }
        finally {
            if (null != classBytes) {
                try {
                    classBytes.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ContinuableClassInfo resolveContinuableClassInfo(String classInternalName, ClassReader reader) {
        ContinuableClassInfo classInfo = this.visitedClasses.get(classInternalName);
        if (classInfo == null) {
            MaybeContinuableClassVisitor maybeContinuableClassVisitor = new MaybeContinuableClassVisitor(this);
            reader.accept((ClassVisitor)maybeContinuableClassVisitor, 6);
            classInfo = maybeContinuableClassVisitor.isContinuable() ? new ContinuableClassInfoInternal(maybeContinuableClassVisitor.isProcessed(), maybeContinuableClassVisitor.continuableMethods) : UNSUPPORTED_CLASS_INFO;
            this.visitedClasses.put(classInternalName, classInfo);
        }
        return classInfo == UNSUPPORTED_CLASS_INFO ? null : classInfo;
    }

    private boolean resolveContinuableAnnotation(String annotationClassDescriptor, ClassReader reader) {
        MaybeContinuableAnnotationVisitor maybeContinuableAnnotationVisitor = new MaybeContinuableAnnotationVisitor(this);
        reader.accept((ClassVisitor)maybeContinuableAnnotationVisitor, 7);
        if (maybeContinuableAnnotationVisitor.isContinuable()) {
            this.markContinuableAnnotation(annotationClassDescriptor);
            return true;
        }
        return false;
    }

    private AnnotationProcessingState getAnnotationProcessingState(String annotationClassDescriptor) {
        if (this.continuableAnnotations.contains(annotationClassDescriptor)) {
            return AnnotationProcessingState.SUPPORTED;
        }
        if (this.processedAnnotations.contains(annotationClassDescriptor)) {
            return AnnotationProcessingState.UNSUPPORTED;
        }
        return AnnotationProcessingState.UNKNON;
    }

    private void markProcessedAnnotation(String annotationClassDescriptor) {
        this.processedAnnotations.add(annotationClassDescriptor);
    }

    private void markContinuableAnnotation(String annotationClassDescriptor) {
        this.markProcessedAnnotation(annotationClassDescriptor);
        this.continuableAnnotations.add(annotationClassDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isContinuableAnnotation(String annotationClassDescriptor) {
        switch (this.getAnnotationProcessingState(annotationClassDescriptor)) {
            case SUPPORTED: {
                return true;
            }
            case UNSUPPORTED: {
                return false;
            }
            case UNKNON: {
                boolean bl;
                this.markProcessedAnnotation(annotationClassDescriptor);
                Type type = Type.getType((String)annotationClassDescriptor);
                InputStream annotationBytes = this.resourceLoader.getResourceAsStream(type.getInternalName() + ".class");
                try {
                    bl = this.resolveContinuableAnnotation(annotationClassDescriptor, new ClassReader(annotationBytes));
                    if (null == annotationBytes) return bl;
                }
                catch (Throwable throwable) {
                    try {
                        if (null == annotationBytes) throw throwable;
                        try {
                            annotationBytes.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                try {
                    annotationBytes.close();
                    return bl;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
        }
        throw new RuntimeException("Unknown annotation kind");
    }

    private static enum AnnotationProcessingState {
        UNKNON,
        UNSUPPORTED,
        SUPPORTED;

    }
}

