/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.multithreading;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;

public class NonThreadSafeSingletonRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> CHECK_NON_STATIC_METHODS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkNonStaticMethods").desc("Check for non-static methods.  Do not set this to false and checkNonStaticFields to true.")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<Boolean> CHECK_NON_STATIC_FIELDS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkNonStaticFields").desc("Check for non-static fields.  Do not set this to true and checkNonStaticMethods to false.")).defaultValue((Object)false)).build();
    private Set<String> fields = new HashSet<String>();
    private boolean checkNonStaticMethods = true;
    private boolean checkNonStaticFields = true;

    public NonThreadSafeSingletonRule() {
        super(ASTFieldDeclaration.class, ASTMethodDeclaration.class);
        this.definePropertyDescriptor(CHECK_NON_STATIC_METHODS_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_NON_STATIC_FIELDS_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        this.fields.clear();
        this.checkNonStaticMethods = (Boolean)this.getProperty(CHECK_NON_STATIC_METHODS_DESCRIPTOR);
        this.checkNonStaticFields = (Boolean)this.getProperty(CHECK_NON_STATIC_FIELDS_DESCRIPTOR);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        if (this.checkNonStaticFields || node.hasModifiers(JModifier.STATIC, new JModifier[0])) {
            for (ASTVariableId varId : node.getVarIds()) {
                this.fields.add(varId.getName());
            }
        }
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        if (this.checkNonStaticMethods && !node.hasModifiers(JModifier.STATIC, new JModifier[0]) || node.hasModifiers(JModifier.SYNCHRONIZED, new JModifier[0])) {
            return data;
        }
        List ifStatements = node.descendants(ASTIfStatement.class).toList();
        for (ASTIfStatement ifStatement : ifStatements) {
            ASTAssignableExpr.ASTNamedReferenceExpr n;
            if (ifStatement.getCondition().descendants(ASTNullLiteral.class).isEmpty() || (n = (ASTAssignableExpr.ASTNamedReferenceExpr)ifStatement.getCondition().descendants(ASTAssignableExpr.ASTNamedReferenceExpr.class).first()) == null || !this.fields.contains(n.getName())) continue;
            List assignments = ifStatement.descendants(ASTAssignmentExpression.class).toList();
            boolean violation = false;
            for (ASTAssignmentExpression assignment : assignments) {
                String name;
                JVariableSymbol referencedSym;
                ASTAssignableExpr left;
                if (assignment.ancestors(ASTSynchronizedStatement.class).nonEmpty() || !((left = assignment.getLeftOperand()) instanceof ASTAssignableExpr.ASTNamedReferenceExpr) || !((referencedSym = ((ASTAssignableExpr.ASTNamedReferenceExpr)left).getReferencedSym()) instanceof JFieldSymbol) || !this.fields.contains(name = ((ASTAssignableExpr.ASTNamedReferenceExpr)left).getName())) continue;
                violation = true;
            }
            if (!violation) continue;
            this.asCtx(data).addViolation((Node)ifStatement);
        }
        return data;
    }
}

