/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.internal;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAssertStatement;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForUpdate;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public class NcssVisitor
extends JavaVisitorBase<MutableInt, Void> {
    protected final boolean countImports;

    public NcssVisitor(MetricOptions options, JavaNode unusedTopNode) {
        this.countImports = options.contains((MetricOption)JavaMetrics.NcssOption.COUNT_IMPORTS);
    }

    @Override
    public final Void visitJavaNode(JavaNode node, MutableInt data) {
        return (Void)super.visitJavaNode(node, (Object)data);
    }

    @Override
    public Void visit(ASTClassDeclaration node, MutableInt data) {
        if (this.countImports) {
            ASTCompilationUnit acu = node.getRoot();
            List imports = acu.children(ASTImportDeclaration.class).toList();
            int increment = imports.size();
            if (acu.children(ASTPackageDeclaration.class).nonEmpty()) {
                ++increment;
            }
            data.add(increment);
        }
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTEnumDeclaration node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTAnnotationTypeDeclaration node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTFieldDeclaration node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, (Object)data);
    }

    @Override
    public Void visit(ASTMethodDeclaration node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTConstructorDeclaration node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTLocalVariableDeclaration node, MutableInt data) {
        if (!(node.getParent() instanceof ASTForInit)) {
            data.increment();
        }
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTIfStatement node, MutableInt data) {
        data.increment();
        if (node.hasElse()) {
            data.increment();
        }
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTWhileStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTSwitchStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTExpressionStatement node, MutableInt data) {
        if (!(((JavaNode)node.getParent()).getParent() instanceof ASTForUpdate)) {
            data.increment();
        }
        return null;
    }

    @Override
    public Void visit(ASTExplicitConstructorInvocation node, MutableInt data) {
        data.increment();
        return null;
    }

    @Override
    public Void visit(ASTContinueStatement node, MutableInt data) {
        data.increment();
        return null;
    }

    @Override
    public Void visit(ASTBreakStatement node, MutableInt data) {
        data.increment();
        return null;
    }

    @Override
    public Void visit(ASTReturnStatement node, MutableInt data) {
        data.increment();
        return null;
    }

    @Override
    public Void visit(ASTDoStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTForStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTSynchronizedStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTCatchClause node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, (Object)data);
    }

    @Override
    public Void visit(ASTThrowStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTFinallyClause node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, (Object)data);
    }

    @Override
    public Void visit(ASTLabeledStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }

    @Override
    public Void visit(ASTSwitchLabel node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, (Object)data);
    }

    @Override
    public Void visit(ASTInitializer node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, (Object)data);
    }

    @Override
    public Void visit(ASTAssertStatement node, MutableInt data) {
        data.increment();
        return (Void)super.visit(node, data);
    }
}

