/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SignatureScanner;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.LexicalScope;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TypeSigParser {
    private TypeSigParser() {
    }

    static int classHeader(int start, TypeScanner b) {
        int cur = TypeSigParser.classType(start, b);
        if (b.charAt(cur) == 'L') {
            ArrayList<JTypeMirror> superItfs = new ArrayList<JTypeMirror>(1);
            do {
                cur = TypeSigParser.classType(cur, b);
                superItfs.add(b.pop());
            } while (b.charAt(cur) == 'L');
            b.pushList(superItfs);
        } else {
            b.pushList(Collections.emptyList());
        }
        return cur;
    }

    static int methodType(int start, TypeScanner b) {
        int cur = TypeSigParser.parameterTypes(start, b);
        cur = TypeSigParser.typeSignature(cur, b, true);
        cur = TypeSigParser.throwsSignaturesOpt(cur, b);
        return cur;
    }

    private static int parameterTypes(int start, TypeScanner b) {
        int cur = b.consumeChar(start, '(', "parameter types");
        if (b.charAt(cur) == ')') {
            b.pushList(Collections.emptyList());
        } else {
            ArrayList<JTypeMirror> params = new ArrayList<JTypeMirror>(1);
            do {
                cur = TypeSigParser.typeSignature(cur, b);
                params.add(b.pop());
            } while (b.charAt(cur) != ')');
            b.pushList(params);
        }
        cur = b.consumeChar(cur, ')');
        return cur;
    }

    private static int throwsSignaturesOpt(int start, TypeScanner b) {
        int cur = start;
        if (b.charAt(cur) == '^') {
            ArrayList<JTypeMirror> thrown = new ArrayList<JTypeMirror>(1);
            do {
                char next;
                if ((next = b.charAt(cur = b.consumeChar(cur, '^', "throws signature"))) != 'T' && next != 'L') {
                    throw b.expected("an exception type", cur);
                }
                cur = TypeSigParser.typeSignature(cur, b);
                thrown.add(b.pop());
            } while (b.charAt(cur) == '^');
            b.pushList(thrown);
        } else {
            b.pushList(Collections.emptyList());
        }
        return cur;
    }

    static int typeVarBound(int start, TypeScanner b) {
        ArrayList<JTypeMirror> bounds = new ArrayList<JTypeMirror>();
        int cur = b.consumeChar(start, ':', "class bound");
        char next = b.charAt(cur);
        if (next == '[' || next == 'L' || next == 'T') {
            cur = TypeSigParser.typeSignature(cur, b);
            bounds.add(b.pop());
        }
        while (b.charAt(cur) == ':') {
            cur = b.consumeChar(cur, ':');
            cur = TypeSigParser.typeSignature(cur, b);
            bounds.add(b.pop());
        }
        if (bounds.isEmpty()) {
            b.push(((TypeScanner)b).ts.OBJECT);
        } else {
            b.push(b.ts.glb(bounds));
        }
        return cur;
    }

    static int typeSignature(int start, TypeScanner b) {
        return TypeSigParser.typeSignature(start, b, false);
    }

    private static int typeSignature(int start, TypeScanner b, boolean acceptVoid) {
        char firstChar = b.charAt(start);
        switch (firstChar) {
            case 'V': {
                if (!acceptVoid) {
                    throw b.expected("a type, got void", start);
                }
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                b.push(b.getBaseType(firstChar));
                return start + 1;
            }
            case '[': {
                return TypeSigParser.arrayType(start, b);
            }
            case 'L': {
                return TypeSigParser.classType(start, b);
            }
            case 'T': {
                return TypeSigParser.typeVar(start, b);
            }
        }
        throw b.expected("type", start);
    }

    private static int classType(int start, TypeScanner b) {
        StringBuilder internalName = new StringBuilder();
        int cur = b.consumeChar(start, 'L', "object type");
        cur = TypeSigParser.classId(cur, b, internalName);
        cur = TypeSigParser.typeArgsOpt(cur, b);
        JClassType t = b.makeClassType(internalName.toString(), b.popList());
        while (b.charAt(cur) == '.') {
            internalName.append('$');
            ++cur;
            cur = TypeSigParser.identifier(cur, b, internalName);
            cur = TypeSigParser.typeArgsOpt(cur, b);
            t = b.parameterize(t, internalName.toString(), b.popList());
        }
        b.push(t);
        return b.consumeChar(cur, ';', "semicolon");
    }

    private static int typeArgsOpt(int start, TypeScanner b) {
        if (b.charAt(start) == '<') {
            ArrayList<JTypeMirror> l = new ArrayList<JTypeMirror>(2);
            int cur = b.consumeChar(start, '<');
            while (b.charAt(cur) != '>') {
                cur = TypeSigParser.typeArg(cur, b);
                l.add(b.pop());
            }
            cur = b.consumeChar(cur, '>');
            b.pushList(l);
            return cur;
        }
        b.pushList(Collections.emptyList());
        return start;
    }

    private static int typeArg(int start, TypeScanner b) {
        int cur = start;
        char firstChar = b.charAt(cur);
        switch (firstChar) {
            case '*': {
                b.push(((TypeScanner)b).ts.UNBOUNDED_WILD);
                return cur + 1;
            }
            case '+': 
            case '-': {
                cur = TypeSigParser.typeSignature(cur + 1, b);
                b.push(b.ts.wildcard(firstChar == '+', b.pop()));
                return cur;
            }
        }
        return TypeSigParser.typeSignature(cur, b);
    }

    private static int arrayType(int start, TypeScanner b) {
        int cur = b.consumeChar(start, '[', "array type");
        cur = TypeSigParser.typeSignature(cur, b);
        b.push(b.ts.arrayType(b.pop()));
        return cur;
    }

    private static int typeVar(int start, TypeScanner b) {
        int cur = b.consumeChar(start, 'T', "type variable");
        StringBuilder nameBuilder = new StringBuilder();
        cur = TypeSigParser.identifier(cur, b, nameBuilder);
        cur = b.consumeChar(cur, ';');
        b.push(b.lookupTvar(nameBuilder.toString()));
        return cur;
    }

    private static int classId(int start, SignatureScanner b, StringBuilder internalName) {
        int cur = start;
        cur = TypeSigParser.identifier(cur, b, null);
        while (b.charAt(cur) == '/') {
            ++cur;
            cur = TypeSigParser.identifier(cur, b, null);
        }
        b.dumpChars(start, cur, internalName);
        return cur;
    }

    static int identifier(int start, SignatureScanner b, @Nullable StringBuilder sb) {
        int cur = start;
        if (!TypeSigParser.isIdentifierChar(b.charAt(cur))) {
            throw b.expected("identifier", cur);
        }
        while (TypeSigParser.isIdentifierChar(b.charAt(++cur))) {
        }
        if (sb != null) {
            b.dumpChars(start, cur, sb);
        }
        return cur;
    }

    private static boolean isIdentifierChar(char c) {
        switch (c) {
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '>': 
            case '[': {
                return false;
            }
        }
        return true;
    }

    static abstract class TypeScanner
    extends SignatureScanner {
        private final Deque<JTypeMirror> typeStack = new ArrayDeque<JTypeMirror>(0);
        private final Deque<List<JTypeMirror>> listStack = new ArrayDeque<List<JTypeMirror>>(0);
        private final TypeSystem ts;
        private final LexicalScope lexicalScope;

        TypeScanner(TypeSystem ts, LexicalScope lexicalScope, String descriptor) {
            super(descriptor);
            this.ts = ts;
            this.lexicalScope = lexicalScope;
        }

        TypeScanner(TypeSystem ts, LexicalScope lexicalScope, String chars, int start, int end) {
            super(chars, start, end);
            this.ts = ts;
            this.lexicalScope = lexicalScope;
        }

        void pushList(List<JTypeMirror> l) {
            this.listStack.push(l);
        }

        void push(JTypeMirror mirror) {
            this.typeStack.push(mirror);
        }

        JTypeMirror pop() {
            return this.typeStack.pop();
        }

        List<JTypeMirror> popList() {
            return this.listStack.pop();
        }

        public abstract @NonNull JClassSymbol makeClassSymbol(String var1, int var2);

        public JTypeMirror getBaseType(char baseType) {
            switch (baseType) {
                case 'V': {
                    return this.ts.NO_TYPE;
                }
                case 'Z': {
                    return this.ts.BOOLEAN;
                }
                case 'C': {
                    return this.ts.CHAR;
                }
                case 'B': {
                    return this.ts.BYTE;
                }
                case 'S': {
                    return this.ts.SHORT;
                }
                case 'I': {
                    return this.ts.INT;
                }
                case 'F': {
                    return this.ts.FLOAT;
                }
                case 'J': {
                    return this.ts.LONG;
                }
                case 'D': {
                    return this.ts.DOUBLE;
                }
            }
            throw new IllegalArgumentException("'" + baseType + "' is not a valid base type descriptor");
        }

        public JTypeMirror lookupTvar(String name) {
            @Nullable JTypeVar mapped = this.lexicalScope.apply(name);
            if (mapped == null) {
                throw new IllegalArgumentException("The lexical scope " + this.lexicalScope + " does not contain an entry for type variable " + name);
            }
            return mapped;
        }

        public JClassType makeClassType(String internalName, List<JTypeMirror> targs) {
            return (JClassType)this.ts.parameterise(this.makeClassSymbol(internalName, targs.size()), targs);
        }

        public JClassType parameterize(JClassType owner, String internalName, List<JTypeMirror> targs) {
            return owner.selectInner(this.makeClassSymbol(internalName, targs.size()), targs);
        }
    }

    static interface ParseFunction {
        public int parse(int var1, TypeScanner var2);
    }
}

