/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.Classpath;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.Loader;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SignatureParser;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AsmSymbolResolver
implements SymbolResolver {
    static final int ASM_API_V = 589824;
    private final TypeSystem ts;
    private final Classpath classLoader;
    private final SignatureParser typeLoader;
    private final ConcurrentMap<String, ClassStub> knownStubs = new ConcurrentHashMap<String, ClassStub>();
    private final ClassStub failed;

    public AsmSymbolResolver(TypeSystem ts, Classpath classLoader) {
        this.ts = ts;
        this.classLoader = classLoader;
        this.typeLoader = new SignatureParser(this);
        this.failed = new ClassStub(this, "/*failed-lookup*/", Loader.FailedLoader.INSTANCE, 0);
    }

    @Override
    public @Nullable JClassSymbol resolveClassFromBinaryName(@NonNull String binaryName) {
        AssertionUtil.requireParamNotNull((String)"binaryName", (Object)binaryName);
        String internalName = AsmSymbolResolver.getInternalName(binaryName);
        ClassStub found = this.knownStubs.computeIfAbsent(internalName, iname -> {
            @Nullable URL url = this.getUrlOfInternalName((String)iname);
            if (url == null) {
                return this.failed;
            }
            return new ClassStub(this, (String)iname, new Loader.UrlLoader(url), 0);
        });
        if (!found.hasCanonicalName()) {
            this.knownStubs.put(internalName, this.failed);
            found = this.failed;
        }
        return found == this.failed ? null : found;
    }

    SignatureParser getSigParser() {
        return this.typeLoader;
    }

    TypeSystem getTypeSystem() {
        return this.ts;
    }

    static @NonNull String getInternalName(@NonNull String binaryName) {
        return binaryName.replace('.', '/');
    }

    @Nullable URL getUrlOfInternalName(String internalName) {
        return this.classLoader.findResource(internalName + ".class");
    }

    @Nullable ClassStub resolveFromInternalNameCannotFail(@Nullable String internalName) {
        if (internalName == null) {
            return null;
        }
        return this.resolveFromInternalNameCannotFail(internalName, 0);
    }

    @NonNull ClassStub resolveFromInternalNameCannotFail(@NonNull String internalName, int observedArity) {
        return this.knownStubs.compute(internalName, (iname, prev) -> {
            if (prev != this.failed && prev != null) {
                return prev;
            }
            @Nullable URL url = this.getUrlOfInternalName((String)iname);
            Loader loader = url == null ? Loader.FailedLoader.INSTANCE : new Loader.UrlLoader(url);
            return new ClassStub(this, (String)iname, loader, observedArity);
        });
    }
}

