/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.internal;

import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TypeResTestRule
extends AbstractJavaRule {
    private static final State STATIC = new State();
    private State state = new State();
    private static final boolean PRINT_ALL_UNRESOLVED = Boolean.parseBoolean(System.getProperties().getOrDefault((Object)"PRINT_ALL_UNRESOLVED", "true").toString());

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        for (JavaNode descendant : node.descendants().crossFindBoundaries()) {
            this.visitJavaNode(descendant, data);
        }
        return data;
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        if (node instanceof TypeNode) {
            try {
                JTypeMirror t = ((TypeNode)node).getTypeMirror();
                TypeSystem ts = t.getTypeSystem();
                if (t == ts.ERROR || t == ts.UNKNOWN) {
                    if (PRINT_ALL_UNRESOLVED) {
                        System.err.println("Unresolved at " + this.position(node) + "\t" + StringUtil.escapeJava((String)StringUtils.truncate((String)node.toString(), (int)100)));
                    }
                    ++this.state.numUnresolved;
                } else {
                    ++this.state.numResolved;
                }
            }
            catch (Throwable e) {
                System.err.println(this.position(node));
                e.printStackTrace();
                ++this.state.numerrors;
                if (e instanceof Error) {
                    // empty if block
                }
            }
        }
        return data;
    }

    public @NonNull String position(JavaNode node) {
        return "In: " + node.getTextDocument().getDisplayName() + ":" + node.getBeginLine() + ":" + node.getBeginColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(RuleContext ctx) {
        super.end(ctx);
        ++this.state.fileId;
        if (this.state.fileId % 200 == 0) {
            int fid;
            State state = STATIC;
            synchronized (state) {
                fid = STATIC.absorb(this.state);
            }
            this.state = new State();
            if (fid % 400 == 0) {
                state = STATIC;
                synchronized (state) {
                    if (TypeResTestRule.STATIC.fileId % 400 == 0) {
                        STATIC.print();
                    }
                }
            }
        }
    }

    private static class State {
        public int fileId = 0;
        public long numResolved = 0L;
        public long numerrors = 0L;
        public long numUnresolved = 0L;

        private State() {
        }

        void print() {
            System.out.println();
            System.out.println(this.fileId);
            System.out.println("Resolved: " + this.numResolved + ", unresolved " + this.numUnresolved);
            double rate = (double)this.numResolved / (double)(this.numUnresolved + this.numResolved);
            System.out.println("Resolved " + Math.floor(1000000.0 * rate) / 10000.0 + "%");
            System.out.println("Errors\t" + this.numerrors);
        }

        int absorb(State other) {
            this.fileId += other.fileId;
            this.numResolved += other.numResolved;
            this.numUnresolved += other.numUnresolved;
            this.numerrors += other.numerrors;
            return this.fileId;
        }
    }
}

