/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class SwitchDensityRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Double> REPORT_LEVEL = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.doubleProperty((String)"minimum").desc("Threshold above which a node is reported")).require(NumericConstraints.positive())).defaultValue((Object)10.0)).build();

    public SwitchDensityRule() {
        super(ASTSwitchStatement.class, ASTSwitchExpression.class);
        this.definePropertyDescriptor(REPORT_LEVEL);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        return this.visitSwitchLike(node, data);
    }

    @Override
    public Object visit(ASTSwitchExpression node, Object data) {
        return this.visitSwitchLike(node, data);
    }

    public Void visitSwitchLike(ASTSwitchLike node, Object data) {
        int labelCount;
        int stmtCount = node.descendants(ASTStatement.class).count();
        double density = (double)stmtCount / (double)(labelCount = node.getBranches().map(ASTSwitchBranch::getLabel).sumBy(label -> label.isDefault() ? 1 : label.getExprList().count()));
        if (density >= (Double)this.getProperty(REPORT_LEVEL)) {
            this.addViolation(data, (Node)node);
        }
        return null;
    }
}

