/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.math.BigInteger;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class NPathComplexityRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("N-Path Complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)200)).build();

    public NPathComplexityRule() {
        super(ASTMethodOrConstructorDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        return this.visitMethod((ASTMethodOrConstructorDeclaration)node, (RuleContext)data);
    }

    private Object visitMethod(ASTMethodOrConstructorDeclaration node, RuleContext data) {
        int reportLevel = (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
        if (!JavaMetrics.NPATH.supports((Node)node)) {
            return data;
        }
        BigInteger npath = (BigInteger)MetricsUtil.computeMetric(JavaMetrics.NPATH, (Node)node);
        if (npath.compareTo(BigInteger.valueOf(reportLevel)) >= 0) {
            this.addViolation(data, (Node)node, new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", PrettyPrintingUtil.displaySignature(node), String.valueOf(npath), String.valueOf(reportLevel)});
        }
        return data;
    }
}

