/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;

public class ExceptionAsFlowControlRule
extends AbstractJavaRulechainRule {
    public ExceptionAsFlowControlRule() {
        super(ASTThrowStatement.class, new Class[0]);
    }

    @Override
    public Object visit(ASTThrowStatement node, Object data) {
        JavaNode firstTryOrCatch = (JavaNode)node.ancestors().map(NodeStream.asInstanceOf(ASTTryStatement.class, (Class[])new Class[]{ASTCatchClause.class})).first();
        NodeStream enclosingTries = node.ancestors(ASTTryStatement.class);
        if (firstTryOrCatch instanceof ASTCatchClause) {
            enclosingTries = enclosingTries.drop(1);
        }
        if (enclosingTries.isEmpty()) {
            return data;
        }
        JTypeMirror thrownType = node.getExpr().getTypeMirror();
        enclosingTries.flatMap(ASTTryStatement::getCatchClauses).map(ASTCatchClause::getParameter).filter(exParam -> exParam.getAllExceptionTypes().any(type -> thrownType.isSubtypeOf(type.getTypeMirror()))).take(1).forEach(ex -> this.addViolation(data, (Node)ex));
        return data;
    }
}

