/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UnnecessaryConstructorRule
extends AbstractIgnoredAnnotationRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTEnumDeclaration.class, (Class[])new Class[]{ASTClassOrInterfaceDeclaration.class});
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Collections.singletonList("javax.inject.Inject");
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isRegularClass()) {
            this.checkClassOrEnum(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.checkClassOrEnum(node, data);
        return data;
    }

    private void checkClassOrEnum(ASTAnyTypeDeclaration node, Object data) {
        List ctors = node.getDeclarations(ASTConstructorDeclaration.class).take(2).toList();
        if (ctors.size() == 1 && this.isExplicitDefaultConstructor(node, (ASTConstructorDeclaration)ctors.get(0))) {
            this.addViolation(data, (Node)ctors.get(0));
        }
    }

    private boolean isExplicitDefaultConstructor(ASTAnyTypeDeclaration declarator, ASTConstructorDeclaration ctor) {
        return ctor.getArity() == 0 && !this.hasIgnoredAnnotation(ctor) && this.hasDefaultCtorVisibility(declarator, ctor) && this.isEmptyBlock(ctor.getBody()) && ctor.getThrowsList() == null;
    }

    private boolean isEmptyBlock(ASTBlock body) {
        ASTStatement stmt;
        if (body.size() == 0) {
            return true;
        }
        if (body.size() == 1 && (stmt = (ASTStatement)body.get(0)) instanceof ASTExplicitConstructorInvocation) {
            ASTExplicitConstructorInvocation superCall = (ASTExplicitConstructorInvocation)stmt;
            return superCall.isSuper() && superCall.getArgumentCount() == 0;
        }
        return false;
    }

    private boolean hasDefaultCtorVisibility(ASTAnyTypeDeclaration node, ASTConstructorDeclaration cons) {
        if (node instanceof ASTClassOrInterfaceDeclaration) {
            return node.getVisibility() == cons.getVisibility();
        }
        if (node instanceof ASTEnumDeclaration) {
            return cons.getVisibility() == AccessNode.Visibility.V_PRIVATE;
        }
        return false;
    }
}

