/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public final class FormalParameterNamingConventionsRule
extends AbstractNamingConventionRule<ASTVariableDeclaratorId> {
    private final PropertyDescriptor<Pattern> formalParamRegex = this.defaultProp("methodParameter", "formal parameter").build();
    private final PropertyDescriptor<Pattern> finalFormalParamRegex = this.defaultProp("finalMethodParameter", "final formal parameter").build();
    private final PropertyDescriptor<Pattern> lambdaParamRegex = this.defaultProp("lambdaParameter", "inferred-type lambda parameter").build();
    private final PropertyDescriptor<Pattern> explicitLambdaParamRegex = this.defaultProp("explicitLambdaParameter", "explicitly-typed lambda parameter").build();

    public FormalParameterNamingConventionsRule() {
        super(ASTVariableDeclaratorId.class, new Class[0]);
        this.definePropertyDescriptor(this.formalParamRegex);
        this.definePropertyDescriptor(this.finalFormalParamRegex);
        this.definePropertyDescriptor(this.lambdaParamRegex);
        this.definePropertyDescriptor(this.explicitLambdaParamRegex);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node.isLambdaParameter()) {
            this.checkMatches(node, node.isTypeInferred() ? this.lambdaParamRegex : this.explicitLambdaParamRegex, data);
        } else if (node.isFormalParameter()) {
            this.checkMatches(node, node.isFinal() ? this.finalFormalParamRegex : this.formalParamRegex, data);
        }
        return data;
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String nameExtractor(ASTVariableDeclaratorId node) {
        return node.getName();
    }

    @Override
    String kindDisplayName(ASTVariableDeclaratorId node, PropertyDescriptor<Pattern> descriptor) {
        if (node.isLambdaParameter()) {
            return node.isTypeInferred() ? "lambda parameter" : "explicitly-typed lambda parameter";
        }
        if (node.isFormalParameter()) {
            return node.isFinal() ? "final method parameter" : "method parameter";
        }
        throw new UnsupportedOperationException("This rule doesn't handle this case");
    }
}

