/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEmptyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class FieldDeclarationsShouldBeAtStartOfClassRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> IGNORE_ANONYMOUS_CLASS_DECLARATIONS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreAnonymousClassDeclarations").defaultValue((Object)true)).desc("Ignore field declarations, that are initialized with an anonymous class creation expression")).build();
    private static final PropertyDescriptor<Boolean> IGNORE_ENUM_DECLARATIONS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreEnumDeclarations").defaultValue((Object)true)).desc("Ignore enum declarations that precede fields")).build();
    private static final PropertyDescriptor<Boolean> IGNORE_INTERFACE_DECLARATIONS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreInterfaceDeclarations").defaultValue((Object)false)).desc("Ignore interface declarations that precede fields")).build();

    public FieldDeclarationsShouldBeAtStartOfClassRule() {
        super(ASTAnyTypeDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(IGNORE_ANONYMOUS_CLASS_DECLARATIONS);
        this.definePropertyDescriptor(IGNORE_INTERFACE_DECLARATIONS);
        this.definePropertyDescriptor(IGNORE_ENUM_DECLARATIONS);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        assert (node instanceof ASTAnyTypeDeclaration);
        return this.visit((ASTAnyTypeDeclaration)node, data);
    }

    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        boolean inStartOfClass = true;
        for (ASTBodyDeclaration declaration : node.getDeclarations()) {
            ASTFieldDeclaration field;
            if (!this.isAllowedAtStartOfClass(declaration)) {
                inStartOfClass = false;
            }
            if (inStartOfClass || !(declaration instanceof ASTFieldDeclaration) || this.isInitializerOk(field = (ASTFieldDeclaration)declaration)) continue;
            this.addViolation(data, (Node)declaration);
        }
        return null;
    }

    private boolean isAllowedAtStartOfClass(ASTBodyDeclaration declaration) {
        return declaration instanceof ASTFieldDeclaration || declaration instanceof ASTInitializer || declaration instanceof ASTEnumConstant || declaration instanceof ASTEmptyDeclaration || declaration instanceof ASTEnumDeclaration && (Boolean)this.getProperty(IGNORE_ENUM_DECLARATIONS) != false || this.isInterface(declaration) && (Boolean)this.getProperty(IGNORE_INTERFACE_DECLARATIONS) != false;
    }

    private boolean isInterface(ASTBodyDeclaration declaration) {
        return declaration instanceof ASTAnyTypeDeclaration && ((ASTAnyTypeDeclaration)declaration).isRegularInterface();
    }

    private boolean isInitializerOk(ASTFieldDeclaration fieldDeclaration) {
        if (((Boolean)this.getProperty(IGNORE_ANONYMOUS_CLASS_DECLARATIONS)).booleanValue() && fieldDeclaration.getVarIds().count() == 1) {
            ASTExpression initializer = ((ASTVariableDeclaratorId)fieldDeclaration.getVarIds().firstOrThrow()).getInitializer();
            return JavaAstUtils.isAnonymousClassCreation(initializer);
        }
        return false;
    }
}

