/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public final class UseTryWithResourcesRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<String>> CLOSE_METHODS = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"closeMethods").desc("Method names in finally block, which trigger this rule")).defaultValues((Object)"close", (Object[])new String[]{"closeQuietly"}).delim(',').build();

    public UseTryWithResourcesRule() {
        super(ASTTryStatement.class, new Class[0]);
        this.definePropertyDescriptor(CLOSE_METHODS);
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        boolean isJava9OrLater = node.getLanguageVersion().compareToVersion("9") >= 0;
        ASTFinallyClause finallyClause = node.getFinallyClause();
        if (finallyClause != null) {
            List methods = finallyClause.descendants(ASTMethodCall.class).filter(m -> ((List)this.getProperty(CLOSE_METHODS)).contains(m.getMethodName())).toList();
            for (ASTMethodCall method : methods) {
                ASTExpression closeTarget = method.getQualifier();
                if ((closeTarget instanceof ASTTypeExpression || !TypeTestUtil.isA(AutoCloseable.class, (TypeNode)closeTarget) || !isJava9OrLater && !JavaAstUtils.isReferenceToLocal(closeTarget)) && !this.hasAutoClosableArguments(method)) continue;
                this.addViolation(data, (Node)node);
                break;
            }
        }
        return data;
    }

    private boolean hasAutoClosableArguments(ASTMethodCall method) {
        return method.getArguments().children().filter(e -> TypeTestUtil.isA(AutoCloseable.class, (TypeNode)e)).nonEmpty();
    }
}

