/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForUpdate;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalClassStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;

public class AvoidReassigningLoopVariablesRule
extends AbstractJavaRulechainRule {
    private static final Map<String, ForeachReassignOption> FOREACH_REASSIGN_VALUES = CollectionUtil.associateBy(Arrays.asList(ForeachReassignOption.values()), ForeachReassignOption::getDisplayName);
    private static final PropertyDescriptor<ForeachReassignOption> FOREACH_REASSIGN = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"foreachReassign", FOREACH_REASSIGN_VALUES).defaultValue((Object)ForeachReassignOption.DENY)).desc("how/if foreach control variables may be reassigned")).build();
    private static final Map<String, ForReassignOption> FOR_REASSIGN_VALUES = CollectionUtil.associateBy(Arrays.asList(ForReassignOption.values()), ForReassignOption::getDisplayName);
    private static final PropertyDescriptor<ForReassignOption> FOR_REASSIGN = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"forReassign", FOR_REASSIGN_VALUES).defaultValue((Object)ForReassignOption.DENY)).desc("how/if for control variables may be reassigned")).build();

    public AvoidReassigningLoopVariablesRule() {
        super(ASTForStatement.class, ASTForeachStatement.class);
        this.definePropertyDescriptor(FOREACH_REASSIGN);
        this.definePropertyDescriptor(FOR_REASSIGN);
    }

    @Override
    public Object visit(ASTForeachStatement loopStmt, Object data) {
        ForeachReassignOption behavior = (ForeachReassignOption)((Object)this.getProperty(FOREACH_REASSIGN));
        if (behavior == ForeachReassignOption.ALLOW) {
            return data;
        }
        ASTVariableDeclaratorId loopVar = loopStmt.getVarId();
        boolean ignoreNext = behavior == ForeachReassignOption.FIRST_ONLY;
        for (ASTAssignableExpr.ASTNamedReferenceExpr usage : loopVar.getLocalUsages()) {
            if (usage.getAccessType() == ASTAssignableExpr.AccessType.WRITE) {
                if (ignoreNext) {
                    ignoreNext = false;
                    continue;
                }
                this.addViolation(data, (Node)usage, loopVar.getName());
                continue;
            }
            ignoreNext = false;
        }
        return null;
    }

    @Override
    public Object visit(ASTForStatement loopStmt, Object data) {
        ForReassignOption behavior = (ForReassignOption)((Object)this.getProperty(FOR_REASSIGN));
        if (behavior == ForReassignOption.ALLOW) {
            return data;
        }
        NodeStream<ASTVariableDeclaratorId> loopVars = JavaAstUtils.getLoopVariables(loopStmt);
        if (behavior == ForReassignOption.DENY) {
            ASTForUpdate update = (ASTForUpdate)loopStmt.firstChild(ASTForUpdate.class);
            for (ASTVariableDeclaratorId loopVar : loopVars) {
                for (ASTAssignableExpr.ASTNamedReferenceExpr usage : loopVar.getLocalUsages()) {
                    if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE || update != null && usage.ancestors(ASTForUpdate.class).first() == update) continue;
                    this.addViolation(data, (Node)usage, loopVar.getName());
                }
            }
        } else {
            Set loopVarNames = (Set)loopVars.collect(Collectors.mapping(ASTVariableDeclaratorId::getName, Collectors.toSet()));
            Set<String> labels = JavaAstUtils.getStatementLabels(loopStmt);
            new ControlFlowCtx(false, loopVarNames, (RuleContext)data, labels, false, false).roamStatementsForExit(loopStmt.getBody());
        }
        return null;
    }

    private static enum ForReassignOption {
        DENY,
        SKIP,
        ALLOW;


        public String toString() {
            return this.getDisplayName();
        }

        public String getDisplayName() {
            return StringUtil.CaseConvention.SCREAMING_SNAKE_CASE.convertTo(StringUtil.CaseConvention.CAMEL_CASE, this.name());
        }
    }

    private static enum ForeachReassignOption {
        DENY,
        FIRST_ONLY,
        ALLOW;


        public String toString() {
            return this.getDisplayName();
        }

        public String getDisplayName() {
            return StringUtil.CaseConvention.SCREAMING_SNAKE_CASE.convertTo(StringUtil.CaseConvention.CAMEL_CASE, this.name());
        }
    }

    class ControlFlowCtx {
        private final boolean guarded;
        private boolean mayExit;
        private final Set<String> loopVarNames;
        private final RuleContext ruleCtx;
        private final Set<String> outerLoopNames;
        private final boolean breakHidden;
        private final boolean continueHidden;

        ControlFlowCtx(boolean guarded, Set<String> loopVarNames, RuleContext ctx, Set<String> outerLoopNames, boolean breakHidden, boolean continueHidden) {
            this.guarded = guarded;
            this.loopVarNames = loopVarNames;
            this.ruleCtx = ctx;
            this.outerLoopNames = outerLoopNames;
            this.breakHidden = breakHidden;
            this.continueHidden = continueHidden;
        }

        ControlFlowCtx withGuard(boolean isGuarded) {
            return this.copy(isGuarded, this.breakHidden, this.continueHidden);
        }

        ControlFlowCtx copy(boolean isGuarded, boolean breakHidden, boolean continueHidden) {
            return new ControlFlowCtx(isGuarded, this.loopVarNames, this.ruleCtx, this.outerLoopNames, breakHidden, continueHidden);
        }

        private boolean roamStatementsForExit(JavaNode node) {
            if (node == null) {
                return false;
            }
            NodeStream unwrappedBlock = node instanceof ASTBlock ? ((ASTBlock)node).toStream() : NodeStream.of((Node)node);
            return this.roamStatementsForExit((NodeStream<? extends JavaNode>)unwrappedBlock);
        }

        private boolean roamStatementsForExit(NodeStream<? extends JavaNode> stmts) {
            for (JavaNode stmt : stmts) {
                String label;
                if (stmt instanceof ASTThrowStatement || stmt instanceof ASTReturnStatement) {
                    return true;
                }
                if (stmt instanceof ASTBreakStatement) {
                    label = ((ASTBreakStatement)stmt).getLabel();
                    return label != null && this.outerLoopNames.contains(label) || !this.breakHidden;
                }
                if (stmt instanceof ASTContinueStatement) {
                    label = ((ASTContinueStatement)stmt).getLabel();
                    return label != null && this.outerLoopNames.contains(label) || !this.continueHidden;
                }
                if (stmt instanceof ASTLoopStatement) {
                    ASTStatement body = ((ASTLoopStatement)stmt).getBody();
                    for (JavaNode child : stmt.children()) {
                        if (child == body) continue;
                        this.checkVorViolations(child);
                    }
                    this.mayExit |= this.copy(true, true, true).roamStatementsForExit(body);
                    continue;
                }
                if (stmt instanceof ASTSwitchStatement) {
                    ASTSwitchStatement switchStmt = (ASTSwitchStatement)stmt;
                    this.checkVorViolations(switchStmt.getTestedExpression());
                    this.mayExit |= this.copy(true, true, false).roamStatementsForExit((NodeStream<? extends JavaNode>)switchStmt.getBranches());
                    continue;
                }
                if (stmt instanceof ASTIfStatement) {
                    ASTIfStatement ifStmt = (ASTIfStatement)stmt;
                    this.checkVorViolations(ifStmt.getCondition());
                    this.mayExit |= this.withGuard(true).roamStatementsForExit(ifStmt.getThenBranch());
                    this.mayExit |= this.withGuard(this.guarded).roamStatementsForExit(ifStmt.getElseBranch());
                    continue;
                }
                if (stmt instanceof ASTExpression) {
                    this.checkVorViolations(stmt);
                    continue;
                }
                if (stmt instanceof ASTLocalClassStatement) continue;
                this.mayExit |= this.roamStatementsForExit((NodeStream<? extends JavaNode>)stmt.children());
            }
            return this.mayExit;
        }

        private void checkVorViolations(JavaNode node) {
            if (node == null) {
                return;
            }
            boolean onlyConsiderWrite = this.guarded || this.mayExit;
            node.descendants(ASTAssignableExpr.ASTNamedReferenceExpr.class).filter(it -> this.loopVarNames.contains(it.getName())).filter(it -> onlyConsiderWrite ? JavaAstUtils.isVarAccessStrictlyWrite(it) : JavaAstUtils.isVarAccessReadAndWrite(it)).forEach(it -> AvoidReassigningLoopVariablesRule.this.addViolation(this.ruleCtx, (Node)it, it.getName()));
        }
    }
}

