/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.NoSuchElementException;
import java.util.Objects;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;

final class TokenUtils {
    private TokenUtils() {
    }

    public static <T extends GenericToken<T>> T nthFollower(T token, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative index?");
        }
        while (n-- > 0 && token != null) {
            token = token.getNext();
        }
        if (token == null) {
            throw new NoSuchElementException("No such token");
        }
        return token;
    }

    public static <T extends GenericToken<T>> T nthPrevious(T startHint, T anchor, int n) {
        Object current;
        if (startHint.compareTo(anchor) >= 0) {
            throw new IllegalStateException("Wrong left hint, possibly not left enough");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Offset can't be less than 1");
        }
        int numAway = 0;
        Object target = startHint;
        for (current = startHint; current != null && !current.equals(anchor); current = current.getNext()) {
            if (numAway == n) {
                target = target.getNext();
                continue;
            }
            ++numAway;
        }
        if (!Objects.equals(current, anchor)) {
            throw new IllegalStateException("Wrong left hint, possibly not left enough");
        }
        if (numAway != n) {
            throw new NoSuchElementException("No such token");
        }
        return target;
    }

    public static void expectKind(JavaccToken token, int kind) {
        assert (token.kind == kind) : "Expected " + token.getDocument().describeKind(kind) + ", got " + token;
    }
}

