/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.security;

import javax.crypto.spec.IvParameterSpec;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class InsecureCryptoIvRule
extends AbstractJavaRule {
    public InsecureCryptoIvRule() {
        this.addRuleChainVisit(ASTAllocationExpression.class);
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (TypeTestUtil.isA(IvParameterSpec.class, (TypeNode)node.getFirstChildOfType(ASTClassOrInterfaceType.class))) {
            Node firstArgument = null;
            ASTArguments arguments = (ASTArguments)node.getFirstChildOfType(ASTArguments.class);
            if (arguments.size() > 0) {
                firstArgument = ((ASTArgumentList)arguments.getFirstChildOfType(ASTArgumentList.class)).getChild(0);
            }
            if (firstArgument != null) {
                ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)firstArgument.getFirstDescendantOfType(ASTPrimaryPrefix.class);
                this.validateProperIv(data, prefix);
            }
        }
        return data;
    }

    private void validateProperIv(Object data, ASTPrimaryPrefix firstArgumentExpression) {
        ASTLiteral literal;
        ASTArrayInitializer arrayInit;
        VariableNameDeclaration varDecl;
        ASTVariableInitializer initializer;
        if (firstArgumentExpression == null) {
            return;
        }
        ASTName namedVar = (ASTName)firstArgumentExpression.getFirstDescendantOfType(ASTName.class);
        if (namedVar != null && namedVar != null && namedVar.getNameDeclaration() instanceof VariableNameDeclaration && (initializer = (ASTVariableInitializer)(varDecl = (VariableNameDeclaration)namedVar.getNameDeclaration()).getAccessNodeParent().getFirstDescendantOfType(ASTVariableInitializer.class)) != null) {
            this.validateProperIv(data, (ASTPrimaryPrefix)initializer.getFirstDescendantOfType(ASTPrimaryPrefix.class));
        }
        if ((arrayInit = (ASTArrayInitializer)firstArgumentExpression.getFirstDescendantOfType(ASTArrayInitializer.class)) != null) {
            this.addViolation(data, (Node)firstArgumentExpression);
        }
        if ((literal = (ASTLiteral)firstArgumentExpression.getFirstDescendantOfType(ASTLiteral.class)) != null && literal.isStringLiteral()) {
            this.addViolation(data, (Node)firstArgumentExpression);
        }
    }
}

