/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class UnnecessaryCaseChangeRule
extends AbstractJavaRule {
    private static final List<String> CASE_CHANGING_METHODS = Arrays.asList("toLowerCase", "toUpperCase");
    private static final List<String> EQUALITY_METHODS = Arrays.asList("equals", "equalsIgnoreCase");

    @Override
    public Object visit(ASTPrimaryExpression expr, Object data) {
        if (this.hasUnnecessaryCaseChange(expr)) {
            this.addViolation(data, (Node)expr);
        }
        return super.visit(expr, data);
    }

    private boolean hasUnnecessaryCaseChange(ASTPrimaryExpression expr) {
        int equalsMethodCallIndex = this.getEqualsMethodCallIndex(expr);
        if (equalsMethodCallIndex != -1) {
            int equalsMethodCallArgsIndex = equalsMethodCallIndex + 1;
            ASTPrimaryExpression equalsCallArgs = this.getMethodCallArgsAtPosition(expr, equalsMethodCallArgsIndex);
            return this.anyHasCaseChangingMethodCall(expr, equalsCallArgs);
        }
        return false;
    }

    private int getEqualsMethodCallIndex(ASTPrimaryExpression expr) {
        for (int callIndex = 0; callIndex < expr.getNumChildren(); ++callIndex) {
            JavaNode methodCall = (JavaNode)expr.getChild(callIndex);
            if (!this.isEqualsMethodCall(methodCall)) continue;
            return callIndex;
        }
        return -1;
    }

    private boolean isEqualsMethodCall(JavaNode methodCall) {
        return this.calledMethodHasNameFromList(methodCall, EQUALITY_METHODS);
    }

    private ASTPrimaryExpression getMethodCallArgsAtPosition(ASTPrimaryExpression expr, int argsPos) {
        if (this.hasChildAtPosition(expr, argsPos)) {
            JavaNode methodCallArgs = (JavaNode)expr.getChild(argsPos);
            return (ASTPrimaryExpression)methodCallArgs.getFirstDescendantOfType(ASTPrimaryExpression.class);
        }
        return null;
    }

    private boolean hasChildAtPosition(ASTPrimaryExpression expr, int pos) {
        return expr.getNumChildren() > pos;
    }

    private boolean anyHasCaseChangingMethodCall(ASTPrimaryExpression ... exprs) {
        for (ASTPrimaryExpression expr : exprs) {
            if (expr == null || !this.hasCaseChangingMethodCall(expr)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCaseChangingMethodCall(ASTPrimaryExpression expr) {
        for (int callArgsIndex = 1; callArgsIndex < expr.getNumChildren(); ++callArgsIndex) {
            JavaNode methodCallArgs;
            JavaNode methodCall = (JavaNode)expr.getChild(callArgsIndex - 1);
            if (!this.isCaseChangingMethodCall(methodCall, methodCallArgs = (JavaNode)expr.getChild(callArgsIndex))) continue;
            return true;
        }
        return false;
    }

    private boolean isCaseChangingMethodCall(JavaNode methodCall, JavaNode methodCallArgs) {
        if (this.calledMethodHasNameFromList(methodCall, CASE_CHANGING_METHODS)) {
            ASTArguments args = (ASTArguments)methodCallArgs.getFirstDescendantOfType(ASTArguments.class);
            return args != null && args.size() == 0;
        }
        return false;
    }

    private boolean calledMethodHasNameFromList(JavaNode methodCall, List<String> nameList) {
        String methodName = this.getCalledMethodName(methodCall);
        if (methodName != null) {
            for (String nameFromList : nameList) {
                if (!methodName.endsWith(nameFromList)) continue;
                return true;
            }
        }
        return false;
    }

    private String getCalledMethodName(JavaNode methodCall) {
        String methodName = methodCall.getImage();
        if (methodName == null) {
            ASTName name = (ASTName)methodCall.getFirstDescendantOfType(ASTName.class);
            return name != null ? this.methodNameFromCallImage(name.getImage()) : null;
        }
        return methodName;
    }

    private String methodNameFromCallImage(String methodCallImage) {
        if (methodCallImage.contains(".")) {
            String[] callParts = methodCallImage.split("\\.");
            return callParts[1];
        }
        return methodCallImage;
    }
}

