/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessTypeNode;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.CommentUtil;
import net.sourceforge.pmd.lang.java.ast.FormalComment;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

@Deprecated
@InternalApi
public abstract class AbstractCommentRule
extends AbstractJavaRule {
    @Deprecated
    protected List<Integer> tagsIndicesIn(String comments) {
        Map<String, Integer> tags = CommentUtil.javadocTagsIn(comments);
        return new ArrayList<Integer>(tags.values());
    }

    protected String filteredCommentIn(Comment comment) {
        return comment.getFilteredComment();
    }

    protected void assignCommentsToDeclarations(ASTCompilationUnit cUnit) {
        SortedMap<Integer, Node> itemsByLineNumber = this.orderedCommentsAndDeclarations(cUnit);
        FormalComment lastComment = null;
        AbstractJavaNode lastNode = null;
        for (Map.Entry<Integer, Node> entry : itemsByLineNumber.entrySet()) {
            Node value = entry.getValue();
            if (value instanceof AbstractJavaAccessNode || value instanceof ASTPackageDeclaration) {
                AbstractJavaNode node = (AbstractJavaNode)value;
                if (lastComment != null && this.isCommentNotWithin(lastComment, (Node)lastNode, value) && this.isCommentBefore(lastComment, value)) {
                    node.comment(lastComment);
                    lastComment = null;
                }
                if (node instanceof AbstractJavaAccessTypeNode) continue;
                lastNode = node;
                continue;
            }
            if (!(value instanceof FormalComment)) continue;
            lastComment = (FormalComment)value;
        }
    }

    private boolean isCommentNotWithin(FormalComment n1, Node n2, Node node) {
        if (n1 == null || n2 == null || node == null) {
            return true;
        }
        boolean isNotWithinNode2 = n1.getEndLine() >= n2.getEndLine() && (n1.getEndLine() != n2.getEndLine() || n1.getEndColumn() >= n2.getEndColumn());
        boolean isNotSameClass = node.getFirstParentOfType(ASTClassOrInterfaceBody.class) != n2.getFirstParentOfType(ASTClassOrInterfaceBody.class);
        boolean isNodeWithinNode2 = node.getEndLine() < n2.getEndLine() || node.getEndLine() == n2.getEndLine() && node.getEndColumn() < n2.getEndColumn();
        return isNotWithinNode2 || isNotSameClass || isNodeWithinNode2;
    }

    private boolean isCommentBefore(FormalComment n1, Node n2) {
        return n1.getEndLine() < n2.getBeginLine() || n1.getEndLine() == n2.getBeginLine() && n1.getEndColumn() < n2.getBeginColumn();
    }

    protected SortedMap<Integer, Node> orderedCommentsAndDeclarations(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Node> itemsByLineNumber = new TreeMap<Integer, Node>();
        this.addDeclarations(itemsByLineNumber, cUnit.findDescendantsOfType(ASTPackageDeclaration.class, true));
        this.addDeclarations(itemsByLineNumber, cUnit.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class, true));
        this.addDeclarations(itemsByLineNumber, cUnit.getComments());
        this.addDeclarations(itemsByLineNumber, cUnit.findDescendantsOfType(ASTFieldDeclaration.class, true));
        this.addDeclarations(itemsByLineNumber, cUnit.findDescendantsOfType(ASTMethodDeclaration.class, true));
        this.addDeclarations(itemsByLineNumber, cUnit.findDescendantsOfType(ASTConstructorDeclaration.class, true));
        this.addDeclarations(itemsByLineNumber, cUnit.findDescendantsOfType(ASTEnumDeclaration.class, true));
        return itemsByLineNumber;
    }

    private void addDeclarations(SortedMap<Integer, Node> map, List<? extends Node> nodes) {
        for (Node node : nodes) {
            map.put((node.getBeginLine() << 16) + node.getBeginColumn(), node);
        }
    }
}

