/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UselessOverridingMethodRule
extends AbstractJavaRule {
    private static final String CLONE_METHOD_NAME = "clone";
    private static final PropertyDescriptor<Boolean> IGNORE_ANNOTATIONS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreAnnotations").defaultValue((Object)false)).desc("Ignore annotations")).build();
    private String packageName;

    public UselessOverridingMethodRule() {
        this.definePropertyDescriptor(IGNORE_ANNOTATIONS_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        this.packageName = "";
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration clz, Object data) {
        if (clz.isInterface()) {
            return data;
        }
        return super.visit(clz, data);
    }

    private boolean isMethodResultType(ASTMethodDeclaration node, Class<?> resultType) {
        ASTResultType type = node.getResultType();
        if (type != null && type.getChild(0) instanceof ASTType) {
            Class<?> resolvedResultType = ((ASTType)type.getChild(0)).getType();
            return resultType.equals(resolvedResultType);
        }
        return false;
    }

    private boolean isMethodThrowingType(ASTMethodDeclaration node, Class<? extends Exception> exceptionType) {
        ASTNameList thrownExceptions = node.getThrows();
        if (thrownExceptions != null) {
            List names = thrownExceptions.findChildrenOfType(ASTName.class);
            for (ASTName name : names) {
                if (name.getType() == null || name.getType() != exceptionType) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object visit(ASTPackageDeclaration node, Object data) {
        this.packageName = node.getPackageNameImage();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        int i;
        ASTPrimaryExpression primaryExpression;
        if (node.isAbstract() || node.isFinal() || node.isNative() || node.isSynchronized()) {
            return super.visit(node, data);
        }
        if (this.isCloneMethod(node)) {
            return super.visit(node, data);
        }
        ASTBlock block = node.getBody();
        if (block == null) {
            return super.visit(node, data);
        }
        if (block.getNumChildren() != 1 || block.findDescendantsOfType(ASTStatement.class).size() != 1) {
            return super.visit(node, data);
        }
        JavaNode statement = ((JavaNode)block.getChild(0)).getChild(0);
        if (statement.getChild(0).getNumChildren() == 0) {
            return data;
        }
        Node statementGrandChild = statement.getChild(0).getChild(0);
        if (statementGrandChild instanceof ASTPrimaryExpression) {
            primaryExpression = (ASTPrimaryExpression)statementGrandChild;
        } else {
            List primaryExpressions = statementGrandChild.findChildrenOfType(ASTPrimaryExpression.class);
            if (primaryExpressions.size() != 1) {
                return super.visit(node, data);
            }
            primaryExpression = (ASTPrimaryExpression)primaryExpressions.get(0);
        }
        ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)primaryExpression.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (!primaryPrefix.usesSuperModifier()) {
            return super.visit(node, data);
        }
        List primarySuffixList = primaryExpression.findChildrenOfType(ASTPrimarySuffix.class);
        if (primarySuffixList.size() != 2) {
            return super.visit(node, data);
        }
        ASTPrimarySuffix primarySuffix = (ASTPrimarySuffix)primarySuffixList.get(0);
        if (!primarySuffix.hasImageEqualTo(node.getName())) {
            return super.visit(node, data);
        }
        primarySuffix = (ASTPrimarySuffix)primarySuffixList.get(1);
        ASTArguments arguments = (ASTArguments)primarySuffix.getChild(0);
        ASTFormalParameters formalParameters = node.getFormalParameters();
        if (formalParameters.getNumChildren() != arguments.getNumChildren()) {
            return super.visit(node, data);
        }
        if (!((Boolean)this.getProperty(IGNORE_ANNOTATIONS_DESCRIPTOR)).booleanValue()) {
            ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.getParent();
            for (i = 0; i < parent.getNumChildren(); ++i) {
                Node n = parent.getChild(i);
                if (!(n instanceof ASTAnnotation) || n.getChild(0) instanceof ASTMarkerAnnotation && "Override".equals(((ASTName)n.getChild(0).getChild(0)).getImage())) continue;
                return super.visit(node, data);
            }
        }
        if (arguments.size() != node.getArity()) {
            return super.visit(node, data);
        }
        if (arguments.size() > 0) {
            ASTArgumentList argumentList = (ASTArgumentList)arguments.getChild(0);
            for (i = 0; i < argumentList.getNumChildren(); ++i) {
                JavaNode expressionChild = ((JavaNode)argumentList.getChild(i)).getChild(0);
                if (!(expressionChild instanceof ASTPrimaryExpression) || expressionChild.getNumChildren() != 1) {
                    return super.visit(node, data);
                }
                ASTPrimaryExpression argumentPrimaryExpression = (ASTPrimaryExpression)expressionChild;
                ASTPrimaryPrefix argumentPrimaryPrefix = (ASTPrimaryPrefix)argumentPrimaryExpression.getChild(0);
                if (argumentPrimaryPrefix.getNumChildren() == 0) {
                    return super.visit(node, data);
                }
                Node argumentPrimaryPrefixChild = argumentPrimaryPrefix.getChild(0);
                if (!(argumentPrimaryPrefixChild instanceof ASTName)) {
                    return super.visit(node, data);
                }
                ASTName argumentName = (ASTName)argumentPrimaryPrefixChild;
                ASTFormalParameter formalParameter = (ASTFormalParameter)formalParameters.getChild(i);
                ASTVariableDeclaratorId variableId = (ASTVariableDeclaratorId)formalParameter.getFirstChildOfType(ASTVariableDeclaratorId.class);
                if (argumentName.hasImageEqualTo(variableId.getImage())) continue;
                return super.visit(node, data);
            }
        }
        if (this.modifiersChanged(node)) {
            return super.visit(node, data);
        }
        this.addViolation(data, node, this.getMessage());
        return super.visit(node, data);
    }

    private boolean isCloneMethod(ASTMethodDeclaration node) {
        boolean isCloneAndPublic = CLONE_METHOD_NAME.equals(node.getName()) && node.isPublic();
        boolean hasNoParameters = node.getArity() == 0;
        return isCloneAndPublic && hasNoParameters && this.isMethodResultType(node, Object.class) && this.isMethodThrowingType(node, CloneNotSupportedException.class);
    }

    private boolean modifiersChanged(ASTMethodDeclaration node) {
        Class<?> type = ((ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)).getType();
        if (type == null) {
            return false;
        }
        String overriddenMethodName = node.getName();
        ArrayList typeArguments = new ArrayList();
        for (ASTFormalParameter parameter : node.getFormalParameters()) {
            Class<?> parameterType = parameter.getType();
            if (parameterType == null) continue;
            typeArguments.add(parameterType);
        }
        if (typeArguments.size() != node.getFormalParameters().size()) {
            return false;
        }
        Class[] typeArgumentArray = typeArguments.toArray(new Class[0]);
        Method declaredMethod = null;
        for (Class<?> superType = type.getSuperclass(); superType != null && declaredMethod == null; superType = superType.getSuperclass()) {
            try {
                declaredMethod = superType.getDeclaredMethod(overriddenMethodName, typeArgumentArray);
                continue;
            }
            catch (NoSuchMethodException | SecurityException e) {
                declaredMethod = null;
            }
        }
        return declaredMethod != null && this.isElevatingAccessModifier(node, declaredMethod);
    }

    private boolean isElevatingAccessModifier(ASTMethodDeclaration overridingMethod, Method superMethod) {
        String superPackageName = null;
        Package p = superMethod.getDeclaringClass().getPackage();
        if (p != null) {
            superPackageName = p.getName();
        }
        boolean elevatingFromProtected = Modifier.isProtected(superMethod.getModifiers()) && !overridingMethod.isProtected();
        boolean elevatingFromPackagePrivate = superMethod.getModifiers() == 0 && overridingMethod.getModifiers() != 0;
        boolean elevatingIntoDifferentPackage = !this.packageName.equals(superPackageName) && !Modifier.isPublic(superMethod.getModifiers());
        return elevatingFromProtected || elevatingFromPackagePrivate || elevatingIntoDifferentPackage;
    }

    @Deprecated
    public <T> List<T> findFirstDegreeChaildrenOfType(Node n, Class<T> targetType) {
        return n.findChildrenOfType(targetType);
    }
}

