/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class IdenticalCatchBranchesRule
extends AbstractJavaRule {
    private boolean areEquivalent(ASTCatchStatement st1, ASTCatchStatement st2) {
        return this.hasSameSubTree((Node)st1.getBody(), (Node)st2.getBody(), st1.getExceptionName(), st2.getExceptionName());
    }

    private Set<List<ASTCatchStatement>> equivalenceClasses(List<ASTCatchStatement> catches) {
        HashSet<List<ASTCatchStatement>> result = new HashSet<List<ASTCatchStatement>>(catches.size());
        for (ASTCatchStatement stmt : catches) {
            if (result.isEmpty()) {
                result.add(this.newEquivClass(stmt));
                continue;
            }
            boolean isNewClass = true;
            for (List list : result) {
                if (!this.areEquivalent(stmt, (ASTCatchStatement)list.get(0))) continue;
                list.add(stmt);
                isNewClass = false;
                break;
            }
            if (!isNewClass) continue;
            result.add(this.newEquivClass(stmt));
        }
        return result;
    }

    private List<ASTCatchStatement> newEquivClass(ASTCatchStatement stmt) {
        ArrayList<ASTCatchStatement> result = new ArrayList<ASTCatchStatement>(2);
        result.add(stmt);
        return result;
    }

    private String getCaughtExceptionsAsString(ASTCatchStatement stmt) {
        StringBuilder sb = new StringBuilder();
        String delim = " | ";
        for (ASTType type : stmt.getCaughtExceptionTypeNodes()) {
            sb.append(type.getTypeImage()).append(" | ");
        }
        sb.replace(sb.length() - 3, sb.length(), "");
        return sb.toString();
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        List<ASTCatchStatement> catchStatements = node.getCatchClauses();
        Set<List<ASTCatchStatement>> equivClasses = this.equivalenceClasses(catchStatements);
        for (List<ASTCatchStatement> identicalStmts : equivClasses) {
            if (identicalStmts.size() <= 1) continue;
            String identicalBranchName = this.getCaughtExceptionsAsString(identicalStmts.get(0));
            for (int i = 1; i < identicalStmts.size(); ++i) {
                this.addViolation(data, (Node)identicalStmts.get(i), new String[]{identicalBranchName});
            }
        }
        return super.visit(node, data);
    }

    private boolean hasSameSubTree(Node node1, Node node2, String exceptionName1, String exceptionName2) {
        if (node1 == null && node2 == null) {
            return true;
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getNumChildren() != node2.getNumChildren()) {
            return false;
        }
        for (int num = 0; num < node1.getNumChildren(); ++num) {
            if (!this.basicEquivalence(node1.getChild(num), node2.getChild(num), exceptionName1, exceptionName2)) {
                return false;
            }
            if (this.hasSameSubTree(node1.getChild(num), node2.getChild(num), exceptionName1, exceptionName2)) continue;
            return false;
        }
        return true;
    }

    private boolean basicEquivalence(Node node1, Node node2, String varName1, String varName2) {
        String image2;
        if (node1.getClass() != node2.getClass()) {
            return false;
        }
        String image1 = node1.getImage();
        return Objects.equals(image1, image2 = node2.getImage()) || Objects.equals(image1, varName1) && Objects.equals(image2, varName2) && this.isNoMethodName(node1) && this.isNoMethodName(node2);
    }

    private boolean isNoMethodName(Node name) {
        Node next;
        Node prefixOrSuffix;
        if (name instanceof ASTName && (name.getParent() instanceof ASTPrimaryPrefix || name.getParent() instanceof ASTPrimarySuffix) && (prefixOrSuffix = name.getParent()).getParent().getNumChildren() > 1 + prefixOrSuffix.getIndexInParent() && (next = prefixOrSuffix.getParent().getChild(prefixOrSuffix.getIndexInParent() + 1)) instanceof ASTPrimarySuffix) {
            return !((ASTPrimarySuffix)next).isArguments();
        }
        return true;
    }
}

