/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl;

import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaClassMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaOperationMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.internal.NcssVisitor;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public final class NcssMetric {

    public static final class NcssOperationMetric
    extends AbstractJavaOperationMetric {
        @Override
        public boolean supports(MethodLikeNode node) {
            return true;
        }

        public double computeFor(MethodLikeNode node, MetricOptions options) {
            MutableInt ncss = (MutableInt)node.jjtAccept(new NcssVisitor(options, node), new MutableInt(0));
            return ncss.getValue().intValue();
        }
    }

    public static final class NcssClassMetric
    extends AbstractJavaClassMetric {
        @Override
        public boolean supports(ASTAnyTypeDeclaration node) {
            return true;
        }

        public double computeFor(ASTAnyTypeDeclaration node, MetricOptions options) {
            MutableInt ncss = (MutableInt)node.jjtAccept(new NcssVisitor(options, node), new MutableInt(0));
            return ncss.getValue().intValue();
        }
    }

    public static enum NcssOption implements MetricOption
    {
        COUNT_IMPORTS("countImports");

        private final String vName;

        private NcssOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }
}

