/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSignature;
import net.sourceforge.pmd.lang.java.rule.documentation.AbstractCommentRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CommentRequiredRule
extends AbstractCommentRule {
    private static final Logger LOG = Logger.getLogger(CommentRequiredRule.class.getName());
    private static final Map<String, String> DESCRIPTOR_NAME_TO_COMMENT_TYPE = new HashMap<String, String>();
    private static final PropertyDescriptor<CommentRequirement> ACCESSOR_CMT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("accessorCommentRequirement", "Comments on getters and setters\"").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final PropertyDescriptor<CommentRequirement> OVERRIDE_CMT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("methodWithOverrideCommentRequirement", "Comments on @Override methods").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final PropertyDescriptor<CommentRequirement> HEADER_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("headerCommentRequirement", "Deprecated! Header comments. Please use the property \"classCommentRequired\" instead.").build();
    private static final PropertyDescriptor<CommentRequirement> CLASS_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("classCommentRequirement", "Class comments").build();
    private static final PropertyDescriptor<CommentRequirement> FIELD_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("fieldCommentRequirement", "Field comments").build();
    private static final PropertyDescriptor<CommentRequirement> PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("publicMethodCommentRequirement", "Public method and constructor comments").build();
    private static final PropertyDescriptor<CommentRequirement> PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("protectedMethodCommentRequirement", "Protected method constructor comments").build();
    private static final PropertyDescriptor<CommentRequirement> ENUM_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("enumCommentRequirement", "Enum comments").build();
    private static final PropertyDescriptor<CommentRequirement> SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("serialVersionUIDCommentRequired", "Serial version UID comments").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final PropertyDescriptor<CommentRequirement> SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("serialPersistentFieldsCommentRequired", "Serial persistent fields comments").defaultValue((Object)CommentRequirement.Ignored)).build();
    private final Map<PropertyDescriptor<CommentRequirement>, CommentRequirement> propertyValues = new HashMap<PropertyDescriptor<CommentRequirement>, CommentRequirement>();

    public CommentRequiredRule() {
        this.definePropertyDescriptor(OVERRIDE_CMT_DESCRIPTOR);
        this.definePropertyDescriptor(ACCESSOR_CMT_DESCRIPTOR);
        this.definePropertyDescriptor(CLASS_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(HEADER_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(ENUM_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        boolean classCommentRequirementValueOverridden;
        this.propertyValues.put(ACCESSOR_CMT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(ACCESSOR_CMT_DESCRIPTOR)));
        this.propertyValues.put(OVERRIDE_CMT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(OVERRIDE_CMT_DESCRIPTOR)));
        this.propertyValues.put(FIELD_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(FIELD_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(ENUM_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(ENUM_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR)));
        CommentRequirement headerCommentRequirementValue = (CommentRequirement)((Object)this.getProperty(HEADER_CMT_REQUIREMENT_DESCRIPTOR));
        boolean headerCommentRequirementValueOverridden = headerCommentRequirementValue != CommentRequirement.Required;
        CommentRequirement classCommentRequirementValue = (CommentRequirement)((Object)this.getProperty(CLASS_CMT_REQUIREMENT_DESCRIPTOR));
        boolean bl = classCommentRequirementValueOverridden = classCommentRequirementValue != CommentRequirement.Required;
        if (headerCommentRequirementValueOverridden && !classCommentRequirementValueOverridden) {
            LOG.warning("Rule CommentRequired uses deprecated property 'headerCommentRequirement'. Future versions of PMD will remove support for this property. Please use 'classCommentRequirement' instead!");
            this.propertyValues.put(CLASS_CMT_REQUIREMENT_DESCRIPTOR, headerCommentRequirementValue);
        } else {
            this.propertyValues.put(CLASS_CMT_REQUIREMENT_DESCRIPTOR, classCommentRequirementValue);
        }
    }

    private void checkCommentMeetsRequirement(Object data, AbstractJavaNode node, PropertyDescriptor<CommentRequirement> descriptor) {
        switch (this.propertyValues.get(descriptor)) {
            case Ignored: {
                break;
            }
            case Required: {
                if (node.comment() != null) break;
                this.commentRequiredViolation(data, node, descriptor);
                break;
            }
            case Unwanted: {
                if (node.comment() == null) break;
                this.commentRequiredViolation(data, node, descriptor);
                break;
            }
        }
    }

    private void commentRequiredViolation(Object data, AbstractJavaNode node, PropertyDescriptor<CommentRequirement> descriptor) {
        this.addViolationWithMessage(data, (Node)node, DESCRIPTOR_NAME_TO_COMMENT_TYPE.get(descriptor.name()) + " are " + ((CommentRequirement)((Object)this.getProperty(descriptor))).label.toLowerCase(Locale.ROOT));
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        this.checkCommentMeetsRequirement(data, decl, CLASS_CMT_REQUIREMENT_DESCRIPTOR);
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration decl, Object data) {
        this.checkMethodOrConstructorComment(decl, data);
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration decl, Object data) {
        if (this.isAnnotatedOverride(decl)) {
            this.checkCommentMeetsRequirement(data, decl, OVERRIDE_CMT_DESCRIPTOR);
        } else if (decl.getSignature().role == JavaOperationSignature.Role.GETTER_OR_SETTER) {
            this.checkCommentMeetsRequirement(data, decl, ACCESSOR_CMT_DESCRIPTOR);
        } else {
            this.checkMethodOrConstructorComment(decl, data);
        }
        return super.visit(decl, data);
    }

    private void checkMethodOrConstructorComment(AbstractJavaAccessNode decl, Object data) {
        if (decl.isPublic()) {
            this.checkCommentMeetsRequirement(data, decl, PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        } else if (decl.isProtected()) {
            this.checkCommentMeetsRequirement(data, decl, PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        }
    }

    private boolean isAnnotatedOverride(ASTMethodDeclaration decl) {
        List annotations = ((JavaNode)decl.getParent()).findDescendantsOfType(ASTMarkerAnnotation.class);
        for (ASTMarkerAnnotation ann : annotations) {
            if (!((ASTName)ann.getFirstChildOfType(ASTName.class)).getImage().equals("Override")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(ASTFieldDeclaration decl, Object data) {
        if (this.isSerialVersionUID(decl)) {
            this.checkCommentMeetsRequirement(data, decl, SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR);
        } else if (this.isSerialPersistentFields(decl)) {
            this.checkCommentMeetsRequirement(data, decl, SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR);
        } else {
            this.checkCommentMeetsRequirement(data, decl, FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        }
        return super.visit(decl, data);
    }

    private boolean isSerialVersionUID(ASTFieldDeclaration field) {
        return "serialVersionUID".equals(field.getVariableName()) && field.isStatic() && field.isFinal() && field.getType() == Long.TYPE;
    }

    private boolean isSerialPersistentFields(ASTFieldDeclaration field) {
        return "serialPersistentFields".equals(field.getVariableName()) && field.isPrivate() && field.isStatic() && field.isFinal() && field.isArray() && "ObjectStreamField".equals(field.jjtGetFirstToken().getImage());
    }

    @Override
    public Object visit(ASTEnumDeclaration decl, Object data) {
        this.checkCommentMeetsRequirement(data, decl, ENUM_CMT_REQUIREMENT_DESCRIPTOR);
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.assignCommentsToDeclarations(cUnit);
        return super.visit(cUnit, data);
    }

    private boolean allCommentsAreIgnored() {
        return this.getProperty(OVERRIDE_CMT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(ACCESSOR_CMT_DESCRIPTOR) == CommentRequirement.Ignored && (this.getProperty(CLASS_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored || this.getProperty(HEADER_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored) && this.getProperty(FIELD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(ENUM_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored;
    }

    public String dysfunctionReason() {
        return this.allCommentsAreIgnored() ? "All comment types are ignored" : null;
    }

    private static PropertyBuilder.GenericPropertyBuilder<CommentRequirement> requirementPropertyBuilder(String name, String commentType) {
        DESCRIPTOR_NAME_TO_COMMENT_TYPE.put(name, commentType);
        return (PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)name, CommentRequirement.mappings()).desc(commentType + ". Possible values: " + CommentRequirement.labels())).defaultValue((Object)CommentRequirement.Required);
    }

    private static enum CommentRequirement {
        Required("Required"),
        Ignored("Ignored"),
        Unwanted("Unwanted");

        private static final List<String> LABELS;
        private static final Map<String, CommentRequirement> MAPPINGS;
        private final String label;

        private CommentRequirement(String theLabel) {
            this.label = theLabel;
        }

        private static List<String> buildValueLabels() {
            ArrayList<String> labels = new ArrayList<String>(CommentRequirement.values().length);
            for (CommentRequirement r : CommentRequirement.values()) {
                labels.add(r.label);
            }
            return Collections.unmodifiableList(labels);
        }

        public static List<String> labels() {
            return LABELS;
        }

        public static Map<String, CommentRequirement> mappings() {
            return MAPPINGS;
        }

        static {
            LABELS = CommentRequirement.buildValueLabels();
            HashMap<String, CommentRequirement> tmp = new HashMap<String, CommentRequirement>();
            for (CommentRequirement r : CommentRequirement.values()) {
                tmp.put(r.label, r);
            }
            MAPPINGS = Collections.unmodifiableMap(tmp);
        }
    }
}

