/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

class AbstractPositionLiteralsFirstInComparisons
extends AbstractJavaRule {
    private final String equalsImage;

    AbstractPositionLiteralsFirstInComparisons(String equalsImage) {
        this.addRuleChainVisit(ASTPrimaryExpression.class);
        this.equalsImage = equalsImage;
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)node.getFirstChildOfType(ASTPrimaryPrefix.class);
        ASTPrimarySuffix primarySuffix = (ASTPrimarySuffix)node.getFirstChildOfType(ASTPrimarySuffix.class);
        if (primaryPrefix != null && primarySuffix != null) {
            ASTName name = (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class);
            if (name == null || !name.getImage().endsWith(this.equalsImage)) {
                return data;
            }
            if (!this.isSingleStringLiteralArgument(primarySuffix)) {
                return data;
            }
            if (this.isWithinNullComparison(node)) {
                return data;
            }
            this.addViolation(data, (Node)node);
        }
        return node;
    }

    private boolean isWithinNullComparison(ASTPrimaryExpression node) {
        for (ASTExpression parentExpr : node.getParentsOfType(ASTExpression.class)) {
            if (!this.isComparisonWithNull(parentExpr, "==", ASTConditionalOrExpression.class) && !this.isComparisonWithNull(parentExpr, "!=", ASTConditionalAndExpression.class)) continue;
            return true;
        }
        return false;
    }

    private boolean isComparisonWithNull(ASTExpression parentExpr, String equalOperator, Class<? extends JavaNode> condition) {
        Node condExpr = null;
        ASTEqualityExpression eqExpr = null;
        if (parentExpr != null) {
            condExpr = (Node)parentExpr.getFirstChildOfType(condition);
        }
        if (condExpr != null) {
            eqExpr = (ASTEqualityExpression)condExpr.getFirstDescendantOfType(ASTEqualityExpression.class);
        }
        if (eqExpr != null) {
            return eqExpr.hasImageEqualTo(equalOperator) && eqExpr.hasDescendantOfType(ASTNullLiteral.class);
        }
        return false;
    }

    private boolean isSingleStringLiteralArgument(ASTPrimarySuffix primarySuffix) {
        ASTLiteral literal;
        if (!primarySuffix.isArguments() || primarySuffix.getArgumentCount() != 1) {
            return false;
        }
        ASTPrimarySuffix node = primarySuffix;
        if ((node = (Node)node.getFirstChildOfType(ASTArguments.class)) != null && (node = (Node)node.getFirstChildOfType(ASTArgumentList.class)).getNumChildren() != 1) {
            return false;
        }
        if (node != null) {
            node = (Node)node.getFirstChildOfType(ASTExpression.class);
        }
        if (node != null) {
            node = (Node)node.getFirstChildOfType(ASTPrimaryExpression.class);
        }
        if (node != null) {
            node = (Node)node.getFirstChildOfType(ASTPrimaryPrefix.class);
        }
        if (node != null) {
            node = (Node)node.getFirstChildOfType(ASTLiteral.class);
        }
        return node != null && (literal = (ASTLiteral)((Object)node)).isStringLiteral();
    }
}

