/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.TypeSet;
import net.sourceforge.pmd.lang.symboltable.Applier;
import net.sourceforge.pmd.lang.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.util.SearchFunction;

public class SourceFileScope
extends AbstractJavaScope {
    private final String packageImage;
    private final TypeSet types;

    public SourceFileScope(ClassLoader classLoader) {
        this(classLoader, "");
    }

    public SourceFileScope(ClassLoader classLoader, String packageImage) {
        this.types = new TypeSet(classLoader);
        this.packageImage = packageImage;
        this.types.setASTCompilationUnitPackage(packageImage);
    }

    public void configureImports(List<ASTImportDeclaration> imports) {
        for (ASTImportDeclaration i : imports) {
            if (i.isImportOnDemand()) {
                this.types.addImport(i.getImportedName() + ".*");
                continue;
            }
            this.types.addImport(i.getImportedName());
        }
    }

    public Set<String> getExplicitImports() {
        return this.types != null ? this.types.getExplicitImports() : Collections.emptySet();
    }

    public boolean hasAuxclasspath() {
        return this.types.hasAuxclasspath();
    }

    public Class<?> resolveType(String name) {
        return this.types.findClass(name);
    }

    public String getPackageName() {
        return this.packageImage;
    }

    @Override
    public void addDeclaration(NameDeclaration declaration) {
        if (!(declaration instanceof ClassNameDeclaration)) {
            throw new IllegalArgumentException("A SourceFileScope can only contain classes.");
        }
        super.addDeclaration(declaration);
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public String toString() {
        return "SourceFileScope: " + this.glomNames(this.getClassDeclarations().keySet());
    }

    public ClassNameDeclaration findClassNameDeclaration(String name) {
        ImageFinderFunction finder = new ImageFinderFunction(name);
        Applier.apply((SearchFunction)finder, this.getClassDeclarations().keySet().iterator());
        return (ClassNameDeclaration)finder.getDecl();
    }

    @Override
    protected Set<NameDeclaration> findVariableHere(JavaNameOccurrence occ) {
        ImageFinderFunction finder = new ImageFinderFunction(occ.getImage());
        Applier.apply((SearchFunction)finder, this.getDeclarations().keySet().iterator());
        if (finder.getDecl() != null) {
            return Collections.singleton(finder.getDecl());
        }
        return Collections.emptySet();
    }

    public Map<String, Node> getQualifiedTypeNames() {
        return this.getSubTypes(null, (Scope)this);
    }

    private Map<String, Node> getSubTypes(String qualifyingName, Scope subType) {
        Set classDeclarations = subType.getDeclarations(ClassNameDeclaration.class).keySet();
        if (classDeclarations.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Node> types = new HashMap<String, Node>((int)((float)classDeclarations.size() / 0.75f) + 1);
        for (ClassNameDeclaration c : classDeclarations) {
            String typeName = c.getName();
            if (qualifyingName != null) {
                typeName = qualifyingName + "." + typeName;
            }
            types.put(typeName, (Node)c.getNode());
            types.putAll(this.getSubTypes(typeName, c.getScope()));
        }
        return types;
    }
}

