/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.string;

import java.util.StringTokenizer;
import net.sf.sfac.string.CharIterator;
import net.sf.sfac.string.StringCharIterator;

public abstract class StringUtils {
    private static final char[] CHAR_MAP = new char[]{'A', 'A', 'A', 'A', 'A', 'A', '\u00c6', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', '\u00d7', 'O', 'U', 'U', 'U', 'U', 'Y', '\u00de', '\u00df', 'a', 'a', 'a', 'a', 'a', 'a', '\u00e6', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'o', 'n', 'o', 'o', 'o', 'o', 'o', '\u00f7', 'o', 'u', 'u', 'u', 'u', 'y', '\u00fe', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', '\u0132', '\u0133', 'J', 'j', 'K', 'k', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', '\u0152', '\u0153', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', '\u017f', '\u0180', '\u0181', '\u0182', '\u0183', '\u0184', '\u0185', '\u0186', '\u0187', '\u0188', '\u0189', '\u018a', '\u018b', '\u018c', '\u018d', '\u018e', '\u018f', '\u0190', '\u0191', 'f', '\u0193', '\u0194', '\u0195', '\u0196', '\u0197', '\u0198', '\u0199', '\u019a', '\u019b', '\u019c', '\u019d', '\u019e', '\u019f', 'O', 'o', '\u01a2', '\u01a3', '\u01a4', '\u01a5', '\u01a6', '\u01a7', '\u01a8', '\u01a9', '\u01aa', '\u01ab', '\u01ac', '\u01ad', '\u01ae', 'U', 'u', '\u01b1', '\u01b2', '\u01b3', '\u01b4', '\u01b5', '\u01b6', '\u01b7', '\u01b8', '\u01b9', '\u01ba', '\u01bb', '\u01bc', '\u01bd', '\u01be', '\u01bf', '\u01c0', '\u01c1', '\u01c2', '\u01c3', '\u01c4', '\u01c5', '\u01c6', '\u01c7', '\u01c8', '\u01c9', '\u01ca', '\u01cb', '\u01cc', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', '\u01dd', '\u01de', '\u01df', '\u01e0', '\u01e1', '\u01e2', '\u01e3', '\u01e4', '\u01e5', '\u01e6', '\u01e7', '\u01e8', '\u01e9', '\u01ea', '\u01eb', '\u01ec', '\u01ed', '\u01ee', '\u01ef', '\u01f0', '\u01f1', '\u01f2', '\u01f3', '\u01f4', '\u01f5', '\u01f6', '\u01f7', '\u01f8', '\u01f9', 'A', 'a', '\u01fc', '\u01fd', 'O', 'o', '\u0200', '\u0201', '\u0202', '\u0203', '\u0204', '\u0205', '\u0206', '\u0207', '\u0208', '\u0209', '\u020a', '\u020b', '\u020c', '\u020d', '\u020e', '\u020f', '\u0210', '\u0211', '\u0212', '\u0213', '\u0214', '\u0215', '\u0216', '\u0217', 'S', 's', 'T', 't', '\u021c', '\u021d', '\u021e', '\u021f'};
    private static StringCharIterator strIterator;

    public static boolean matchString(String pattern, CharIterator src, boolean ignoreCase) {
        int patternLen;
        boolean matched = false;
        if (pattern == null) {
            pattern = "";
        }
        if (ignoreCase) {
            pattern = pattern.toLowerCase();
        }
        if ((patternLen = pattern.length()) > 0) {
            int matchedIndex = 0;
            char ch = src.nextChar();
            while (ch != '\u0000') {
                if (ignoreCase) {
                    ch = Character.toLowerCase(ch);
                }
                if (pattern.charAt(matchedIndex) == ch) {
                    if (++matchedIndex >= patternLen) {
                        matched = true;
                        break;
                    }
                } else {
                    matchedIndex = pattern.charAt(0) == ch ? 1 : 0;
                }
                ch = src.nextChar();
            }
        } else {
            matched = true;
        }
        return matched;
    }

    public static boolean matchPattern(String pattern, CharIterator src) {
        boolean matched = false;
        int patternLen = (pattern = StringUtils.getNormalizedString(pattern)).length();
        if (patternLen > 0) {
            int matchedIndex = 0;
            char ch = src.nextNormalizedChar();
            while (ch != '\u0000') {
                if (pattern.charAt(matchedIndex) == ch) {
                    if (++matchedIndex >= patternLen) {
                        matched = true;
                        break;
                    }
                } else {
                    matchedIndex = pattern.charAt(0) == ch ? 1 : 0;
                }
                ch = src.nextNormalizedChar();
            }
        } else {
            matched = true;
        }
        return matched;
    }

    public static boolean areEquals(CharIterator it1, CharIterator it2, boolean normalized) {
        char ch2;
        char ch1 = normalized ? it1.nextNormalizedChar() : it1.nextChar();
        char c = ch2 = normalized ? it2.nextNormalizedChar() : it2.nextChar();
        if (normalized) {
            while (ch1 == ' ') {
                ch1 = it1.nextNormalizedChar();
            }
            while (ch2 == ' ') {
                ch2 = it2.nextNormalizedChar();
            }
        }
        while (ch1 != '\u0000' && ch2 != '\u0000' && ch1 == ch2) {
            ch1 = normalized ? it1.nextNormalizedChar() : it1.nextChar();
            ch2 = normalized ? it2.nextNormalizedChar() : it2.nextChar();
        }
        if (normalized && (ch1 == '\u0000' || ch2 == '\u0000')) {
            while (ch1 == ' ') {
                ch1 = it1.nextNormalizedChar();
            }
            while (ch2 == ' ') {
                ch2 = it2.nextNormalizedChar();
            }
        }
        return ch1 == ch2;
    }

    public static boolean matchKeywords(String keywords, boolean matchAll, CharIterator src) {
        String[] keyWords = StringUtils.getNormalizedKeywords(keywords);
        return StringUtils.matchNormalizedKeywords(keyWords, matchAll, src);
    }

    public static String[] getNormalizedKeywords(String keywordString) {
        keywordString = StringUtils.getNormalizedString(keywordString);
        StringTokenizer tokenizer = new StringTokenizer(keywordString, " ");
        int nbrKey = tokenizer.countTokens();
        String[] keyWords = new String[nbrKey];
        for (int i = 0; i < nbrKey; ++i) {
            keyWords[i] = tokenizer.nextToken();
        }
        return keyWords;
    }

    public static boolean matchNormalizedKeywords(String[] keywords, boolean matchAll, CharIterator src) {
        int nbrKey;
        boolean matched = false;
        int n = nbrKey = keywords == null ? 0 : keywords.length;
        if (nbrKey > 0) {
            int i;
            int[] matchedIndex = new int[nbrKey];
            boolean[] matchedKey = new boolean[nbrKey];
            char ch = src.nextNormalizedChar();
            while (ch != '\u0000') {
                for (i = 0; i < nbrKey; ++i) {
                    if (keywords[i].charAt(matchedIndex[i]) == ch) {
                        int n2 = i;
                        matchedIndex[n2] = matchedIndex[n2] + 1;
                        if (matchedIndex[i] < keywords[i].length()) continue;
                        if (matchAll) {
                            matchedKey[i] = true;
                            matchedIndex[i] = 0;
                            continue;
                        }
                        matched = true;
                        break;
                    }
                    matchedIndex[i] = keywords[i].charAt(0) == ch ? 1 : 0;
                }
                if (matched) break;
                ch = src.nextNormalizedChar();
            }
            if (matchAll) {
                matched = true;
                for (i = 0; i < nbrKey; ++i) {
                    if (matchedKey[i]) continue;
                    matched = false;
                    break;
                }
            }
        } else {
            matched = true;
        }
        return matched;
    }

    public static String getNormalizedString(String src) {
        if (strIterator == null) {
            strIterator = new StringCharIterator(src);
        } else {
            strIterator.setData(src);
        }
        return strIterator.getNormalizedString();
    }

    public static final char removeDiacritic(char ch) {
        if (ch < '\u00c0' || ch > '\u021f') {
            return ch;
        }
        return CHAR_MAP[ch - 192];
    }

    public static final char getUppercaseChar(char ch) {
        char nonAccentued = StringUtils.removeDiacritic(ch);
        return Character.toUpperCase(nonAccentued);
    }

    public static final String firstToUpperCase(String src) {
        if (src == null) {
            return null;
        }
        int len = src.length();
        if (len == 0) {
            return src;
        }
        if (len == 1) {
            return String.valueOf(StringUtils.getUppercaseChar(src.charAt(0)));
        }
        return String.valueOf(StringUtils.getUppercaseChar(src.charAt(0))) + src.substring(1);
    }

    public static final String firstToLowerCase(String src) {
        if (src == null) {
            return null;
        }
        int len = src.length();
        if (len == 0) {
            return src;
        }
        if (len == 1) {
            return String.valueOf(Character.toLowerCase(src.charAt(0)));
        }
        return String.valueOf(Character.toLowerCase(src.charAt(0))) + src.substring(1);
    }

    public static final String firstOfWordsUpperCase(String src) {
        return StringUtils.firstOfWordsUpperCase(src, false);
    }

    public static final String firstOfWordsUpperCase(String src, boolean othersToLowercase) {
        StringBuffer sb = new StringBuffer(src);
        boolean previousIsWhite = true;
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (previousIsWhite) {
                sb.setCharAt(i, StringUtils.getUppercaseChar(ch));
            } else if (othersToLowercase) {
                sb.setCharAt(i, Character.toLowerCase(ch));
            }
            previousIsWhite = ch <= ' ';
        }
        return sb.toString();
    }

    public static final String getEncodedString(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        int len = src.length();
        boolean lastBlanc = true;
        for (int i = 0; i < len; ++i) {
            boolean isBlanc;
            char ch = StringUtils.removeDiacritic(src.charAt(i));
            if (ch >= 'a' && ch <= 'z') {
                isBlanc = false;
            } else if (ch >= 'A' && ch <= 'Z') {
                isBlanc = false;
                ch = Character.toLowerCase(ch);
            } else {
                isBlanc = ch < '0' || ch > '9';
            }
            if (!isBlanc) {
                if (lastBlanc) {
                    ch = Character.toUpperCase(ch);
                }
                res.append(ch);
            }
            lastBlanc = isBlanc;
        }
        return res.toString();
    }
}

