/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.string;

import net.sf.sfac.string.CharIterator;
import net.sf.sfac.string.StringUtils;

public abstract class AbstractCharIterator
implements CharIterator {
    private String currentString;
    private int currentStringLen;
    private int currentIndex;
    private boolean finished;
    private boolean lastWhite;

    public void reset() {
        this.finished = false;
        this.lastWhite = true;
        this.currentIndex = 0;
        this.currentString = this.getFirstString();
        if (this.currentString == null) {
            this.currentString = "";
        }
        this.currentStringLen = this.currentString.length();
    }

    protected abstract String getFirstString();

    protected abstract String getNextString();

    protected void setFinished() {
        this.finished = true;
    }

    protected boolean isFinished() {
        return this.finished;
    }

    public char nextNormalizedChar() {
        if (this.finished) {
            return '\u0000';
        }
        int ch = 0;
        boolean continueRead = true;
        while (continueRead) {
            ch = this.nextChar();
            if ((ch = StringUtils.removeDiacritic((char)ch)) == 0) {
                this.finished = true;
                continueRead = false;
                continue;
            }
            if (Character.isLetter((char)ch)) {
                ch = Character.toLowerCase((char)ch);
                this.lastWhite = false;
                continueRead = false;
                continue;
            }
            if (Character.isDigit((char)ch)) {
                this.lastWhite = false;
                continueRead = false;
                continue;
            }
            if (this.lastWhite) continue;
            ch = 32;
            this.lastWhite = true;
            continueRead = false;
        }
        return (char)ch;
    }

    public char nextChar() {
        char ch = '\u0000';
        boolean continueRead = true;
        while (continueRead && !this.finished) {
            if (this.currentIndex < this.currentStringLen) {
                ch = this.currentString.charAt(this.currentIndex);
                ++this.currentIndex;
                continueRead = false;
                continue;
            }
            this.currentString = this.getNextString();
            if (this.currentString == null) {
                this.currentString = "";
            }
            this.currentStringLen = this.currentString.length();
            this.currentIndex = 0;
        }
        return ch;
    }

    public String getNormalizedString() {
        this.reset();
        StringBuffer sb = new StringBuffer();
        char ch = this.nextNormalizedChar();
        while (ch != '\u0000') {
            sb.append(ch);
            ch = this.nextNormalizedChar();
        }
        return sb.toString().trim();
    }
}

