/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.lang;

import java.util.Locale;
import net.sf.sfac.lang.LanguageListener;
import net.sf.sfac.lang.LanguageSupportMock;

public abstract class LanguageSupport {
    private static LanguageSupport instance;

    public static LanguageSupport getInstance() {
        if (instance == null) {
            instance = new LanguageSupportMock();
        }
        return instance;
    }

    public static void setInstance(LanguageSupport newInstance) {
        instance = newInstance;
    }

    public static String getLocalizedString(String key) {
        return LanguageSupport.getInstance().getLocalizedStringImpl(key);
    }

    public static String getLocalizedString(String key, Object ... params) {
        return LanguageSupport.getInstance().getLocalizedStringImpl(key, params);
    }

    public static String getOptionalLocalizedString(String key, String defaultValue) {
        return LanguageSupport.getInstance().getOptionalLocalizedStringImpl(key, defaultValue);
    }

    public static void updateLanguage(String newLocaleId) {
        LanguageSupport.getInstance().updateLanguageImpl(newLocaleId);
    }

    public static Locale getCurrentLocale() {
        return LanguageSupport.getInstance().getCurrentLocaleImpl();
    }

    public static void addLanguageListener(LanguageListener lis) {
        LanguageSupport.getInstance().addLanguageListenerImpl(lis);
    }

    public static void removeLanguageListener(LanguageListener lis) {
        LanguageSupport.getInstance().removeLanguageListenerImpl(lis);
    }

    public abstract LanguageSupport copyInstance();

    public abstract String getLocalizedStringImpl(String var1);

    public abstract String getLocalizedStringImpl(String var1, Object ... var2);

    public abstract String getOptionalLocalizedStringImpl(String var1, String var2);

    public abstract void updateLanguageImpl(String var1);

    public abstract Locale getCurrentLocaleImpl();

    public abstract void addLanguageListenerImpl(LanguageListener var1);

    public abstract void removeLanguageListenerImpl(LanguageListener var1);
}

