/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.sfac.file.FilePathUtils;

public class FileUtils {
    public static void copyFile(File source, File target) throws IOException {
        if (!source.exists()) {
            throw new IOException("Source must exists: " + source);
        }
        if (!source.isFile()) {
            throw new IOException("Source must be a file: " + source);
        }
        FileInputStream is = new FileInputStream(source);
        FileOutputStream os = new FileOutputStream(target);
        FileUtils.copyFile(is, os);
        is.close();
        os.close();
    }

    public static void copyFile(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
    }

    public static boolean areFilesEqual(File f1, File f2) throws IOException {
        if (!f1.exists()) {
            throw new IOException("Source must exists: " + f1);
        }
        if (!f2.isFile()) {
            throw new IOException("Source must be a file: " + f2);
        }
        FileInputStream in1 = new FileInputStream(f1);
        FileInputStream in2 = new FileInputStream(f2);
        boolean equals = FileUtils.areFilesEqual(in1, in2);
        in1.close();
        in2.close();
        return equals;
    }

    public static boolean areFilesEqual(InputStream in1, InputStream in2) throws IOException {
        BufferedInputStream bi1 = in1 instanceof BufferedInputStream ? (BufferedInputStream)in1 : new BufferedInputStream(in1);
        BufferedInputStream bi2 = in2 instanceof BufferedInputStream ? (BufferedInputStream)in2 : new BufferedInputStream(in2);
        int ch1 = bi1.read();
        int ch2 = bi2.read();
        while (ch1 >= 0 && ch2 >= 0 && ch1 == ch2) {
            ch1 = bi1.read();
            ch2 = bi2.read();
        }
        return ch1 < 0 && ch2 < 0;
    }

    public static void moveFile(File source, File target) throws IOException {
        if (!source.exists()) {
            throw new IOException("Source must exists: " + source);
        }
        if (target.exists()) {
            throw new IOException("Target already exists: " + target);
        }
        FileUtils.ensureParentDirectoryExists(target);
        boolean success = source.renameTo(target);
        if (!success) {
            throw new IOException("Failed to move " + source + " to " + target);
        }
    }

    public static void ensureParentDirectoryExists(File f) throws IOException {
        boolean success;
        File parentDir = f.getAbsoluteFile().getParentFile();
        if (parentDir != null && !parentDir.exists() && !(success = parentDir.mkdirs())) {
            throw new IOException("Failed to create parent directory " + parentDir);
        }
    }

    public static void deleteFile(File fil) throws IOException {
        if (!fil.exists()) {
            throw new IOException("File must exists: " + fil);
        }
        boolean success = fil.delete();
        if (!success) {
            throw new IOException("Failed to delete " + fil);
        }
    }

    public static void renameToBackup(File source) throws IOException {
        File renamed;
        if (!source.exists()) {
            throw new IOException("Source must exists: " + source);
        }
        File dir = source.getParentFile();
        String sourceName = source.getName();
        String ext = FilePathUtils.getExtension(sourceName);
        String nameWithoutExt = ext == null ? sourceName : sourceName.substring(0, sourceName.length() - (ext.length() + 1));
        int i = 1;
        while (true) {
            StringBuffer sb = new StringBuffer().append(nameWithoutExt).append("_").append(i);
            if (ext != null) {
                sb.append(".").append(ext);
            }
            String newName = sb.toString();
            File file = renamed = dir == null ? new File(newName) : new File(dir, newName);
            if (!renamed.exists()) break;
            ++i;
        }
        FileUtils.moveFile(source, renamed);
    }

    public static String removeReservedFileCharacters(String src) {
        if (src == null) {
            return null;
        }
        int len = src.length();
        if (len == 0) {
            return "";
        }
        boolean needChange = FileUtils.isReservedFileBoundCharacters(src.charAt(0));
        if (!needChange) {
            needChange = FileUtils.isReservedFileBoundCharacters(src.charAt(len - 1));
        }
        for (int i = 1; i < len && !needChange; ++i) {
            needChange = FileUtils.isReservedFileCharacters(src.charAt(i));
        }
        if (needChange) {
            for (int startIndex = 0; startIndex < len && FileUtils.isReservedFileBoundCharacters(src.charAt(startIndex)); ++startIndex) {
            }
            StringBuilder sb = new StringBuilder();
            for (int i = startIndex; i < len; ++i) {
                if (FileUtils.isReservedFileCharacters(src.charAt(i))) continue;
                sb.append(src.charAt(i));
            }
            while (sb.length() > 0 && FileUtils.isReservedFileBoundCharacters(sb.charAt(sb.length() - 1))) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        return src;
    }

    public static boolean isReservedFileCharacters(char ch) {
        if (ch == '/') {
            return true;
        }
        if (ch == '\\') {
            return true;
        }
        if (ch == '*') {
            return true;
        }
        if (ch == '?') {
            return true;
        }
        if (ch == '\"') {
            return true;
        }
        if (ch == '\n') {
            return true;
        }
        if (ch == '\t') {
            return true;
        }
        return ch == ':';
    }

    public static boolean isReservedFileBoundCharacters(char ch) {
        if (FileUtils.isReservedFileCharacters(ch)) {
            return true;
        }
        if (ch == '.') {
            return true;
        }
        return ch == ' ';
    }

    public static InputStream getUncloseableStream(InputStream is) {
        return new UncloseableStream(is);
    }

    static class UncloseableStream
    extends InputStream {
        InputStream wrapped;

        UncloseableStream(InputStream wrappedStream) {
            this.wrapped = wrappedStream;
        }

        public void close() throws IOException {
        }

        public int read() throws IOException {
            return this.wrapped.read();
        }

        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.wrapped.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        public int available() throws IOException {
            return this.wrapped.available();
        }

        public void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        public void reset() throws IOException {
            this.wrapped.reset();
        }

        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }
}

