/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import net.sf.sfac.lang.LanguageSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileType implements FileFilter,
FilenameFilter
{
    FILE_TYPE_ALL("All files (*.*)", null),
    FILE_TYPE_TEXT("Text files (*.txt)", new String[]{"txt", "text"}),
    FILE_TYPE_XML("XML files (*.xml)", new String[]{"xml"}),
    FILE_TYPE_PROPERTIES("Properties files (*.properties)", new String[]{"properties"}),
    FILE_TYPE_PNG("Portable Network Graphics (*.png)", new String[]{"png"}),
    FILE_TYPE_JPEG("Jpeg images (*.jpg, *.jpeg)", new String[]{"jpg", "jpeg"}),
    FILE_TYPE_GIF("Gif images (*.gif)", new String[]{"gif"}),
    FILE_TYPE_IMAGES("All images (*.jpg, *.gif, *.png)", new String[]{"jpg", "png", "gif", "jpeg"}),
    FILE_TYPE_PDF("Portable Document Format (*.pdf)", new String[]{"pdf"}),
    FILE_TYPE_ZIP("Compressed archives (*.zip)", new String[]{"zip"}),
    FILE_TYPE_CBZ("Comic Book (*.cbz)", new String[]{"cbz"}),
    FILE_TYPE_HTML("HTML files (*.html, *.htm)", new String[]{"html", "htm"}),
    FILE_TYPE_DB("Database files (*.db4o)", new String[]{"db4o"}),
    FILE_TYPE_CSV("Coma separated (*.csv)", new String[]{"csv"}),
    FILE_TYPE_FO("XSL-FO xml documents (*.fo)", new String[]{"fo", "xsl-fo"}),
    FILE_TYPE_SONG("Song (*.sng)", new String[]{"sng"}),
    FILE_TYPE_MP3("Audio (*.mp3)", new String[]{"mp3"}),
    FILE_TYPE_VIDEO("Movie (*.mp4, *.avi, *.mov)", new String[]{"mp4", "avi", "mov"});

    private String defaultDescription;
    private String[] extensions;

    public static FileType getFileType(File fil, FileType[] possibleTypes, FileType defaultType) {
        for (FileType type : possibleTypes) {
            if (type == FILE_TYPE_ALL || !type.isFileOfType(fil)) continue;
            return type;
        }
        return defaultType;
    }

    public static File setFileExtension(File fil, FileType type, boolean overrideExisting) {
        String newFileName;
        if (type.isFileOfType(fil)) {
            return fil;
        }
        String defaultExt = type.getDefaultExtension();
        if (defaultExt == null) {
            return fil;
        }
        String fileName = fil.getName();
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            newFileName = fileName + '.' + defaultExt;
        } else if (overrideExisting) {
            newFileName = fileName.substring(0, lastDotIndex + 1) + defaultExt;
        } else {
            return fil;
        }
        File parentDir = fil.getParentFile();
        File newFile = parentDir == null ? new File(newFileName) : new File(parentDir, newFileName);
        return newFile;
    }

    public static void addChoosableFileFilters(JFileChooser chooser, FileType[] types, boolean addAllFilter) {
        if (addAllFilter) {
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addChoosableFileFilter(FILE_TYPE_ALL.getFileChooserFilter());
        }
        int len = types == null ? 0 : types.length;
        for (int i = len - 1; i >= 0; ++i) {
            chooser.addChoosableFileFilter(types[i].getFileChooserFilter());
        }
    }

    public static String getFileExtension(String fileName) {
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private FileType(String typeDescription, String[] fileExtensions) {
        this.defaultDescription = typeDescription;
        this.extensions = fileExtensions;
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public String getDefaultExtension() {
        return this.extensions == null ? null : this.extensions[0];
    }

    public String[] getAcceptedExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = FileType.getFileExtension(f.getName());
        return this.isAcceptedExtension(extension);
    }

    @Override
    public boolean accept(File dir, String name) {
        String extension = FileType.getFileExtension(name);
        return this.isAcceptedExtension(extension);
    }

    public boolean isFileOfType(File fil) {
        if (fil == null || fil.isDirectory()) {
            return false;
        }
        return this.accept(fil);
    }

    public boolean isAcceptedExtension(String extension) {
        if (this.extensions == null) {
            return true;
        }
        int len = this.extensions.length;
        for (int i = 0; i < len; ++i) {
            if (!this.extensions[i].equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.name() + ']';
    }

    FileChooserFilter getFileChooserFilter() {
        String descr = this.defaultDescription;
        String key = this.name() + "_DESCR";
        descr = LanguageSupport.getLocalizedString(key);
        if (descr == key) {
            descr = this.defaultDescription;
        }
        return new FileChooserFilter(descr);
    }

    class FileChooserFilter
    extends javax.swing.filechooser.FileFilter {
        String chooserDescription;

        FileChooserFilter(String descr) {
            this.chooserDescription = descr;
        }

        public boolean accept(File f) {
            return FileType.this.accept(f);
        }

        public String getDescription() {
            return this.chooserDescription;
        }
    }
}

