/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.ArithmeticExpression10;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.IntegerRangeTest;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LastItemExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SubscriptExpression;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.functions.PositionAndLast;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.GeneralNodePattern;
import net.sf.saxon.pattern.GeneralPositionalPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.pattern.SimplePositionalPattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public final class FilterExpression
extends BinaryExpression
implements ContextSwitchingExpression {
    private boolean filterIsPositional;
    private boolean filterIsSingletonBoolean;
    private boolean filterIsIndependent;
    public static final int FILTERED = 10000;
    public static final OperandRole FILTER_PREDICATE = new OperandRole(6, OperandUsage.INSPECTION, SequenceType.ANY_SEQUENCE);

    public FilterExpression(Expression base, Expression filter) {
        super(base, 4, filter);
        base.setFiltered(true);
    }

    protected OperandRole getOperandRole(int arg) {
        return arg == 0 ? OperandRole.SAME_FOCUS_ACTION : FILTER_PREDICATE;
    }

    public Expression getBase() {
        return this.getLhsExpression();
    }

    public void setBase(Expression base) {
        this.setLhsExpression(base);
    }

    public Expression getFilter() {
        return this.getRhsExpression();
    }

    public void setFilter(Expression filter) {
        this.setRhsExpression(filter);
    }

    public String getExpressionName() {
        return "filter";
    }

    public ItemType getItemType() {
        if (this.getFilter() instanceof InstanceOfExpression && ((InstanceOfExpression)this.getFilter()).getBaseExpression() instanceof ContextItemExpression) {
            return ((InstanceOfExpression)this.getFilter()).getRequiredItemType();
        }
        return this.getBase().getItemType();
    }

    public Expression getSelectExpression() {
        return this.getBase();
    }

    public boolean isFilterIsPositional() {
        return this.filterIsPositional;
    }

    public Expression getActionExpression() {
        return this.getFilter();
    }

    public boolean isPositional(TypeHierarchy th) {
        return FilterExpression.isPositionalFilter(this.getFilter(), th);
    }

    public boolean isSimpleBooleanFilter() {
        return this.filterIsSingletonBoolean;
    }

    public boolean isIndependentFilter() {
        return this.filterIsIndependent;
    }

    public Expression simplify() throws XPathException {
        this.setBase(this.getBase().simplify());
        this.setFilter(this.getFilter().simplify());
        if (Literal.isEmptySequence(this.getBase())) {
            return this.getBase();
        }
        if (this.getFilter() instanceof Literal && !(((Literal)this.getFilter()).getValue() instanceof NumericValue)) {
            try {
                if (this.getFilter().effectiveBooleanValue(new EarlyEvaluationContext(this.getConfiguration()))) {
                    return this.getBase();
                }
                return Literal.makeEmptySequence();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
        }
        if (this.getFilter().isCallOn(PositionAndLast.Last.class)) {
            this.setFilter(new IsLastExpression(true));
            this.adoptChildExpression(this.getFilter());
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        this.getLhs().typeCheck(visitor, contextInfo);
        this.getBase().setFiltered(true);
        if (Literal.isEmptySequence(this.getBase())) {
            return this.getBase();
        }
        this.getRhs().typeCheck(visitor, new ContextItemStaticInfo(this.getBase().getItemType(), false, this.getBase()));
        Expression filter2 = ExpressionTool.unsortedIfHomogeneous(this.getFilter(), visitor.isOptimizeForStreaming());
        if (filter2 != this.getFilter()) {
            this.setFilter(filter2);
        }
        if (Literal.isConstantOne(this.getFilter())) {
            Expression fie = FirstItemExpression.makeFirstItemExpression(this.getBase());
            ExpressionTool.copyLocationInfo(this, fie);
            return fie;
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.getFilter(), th);
        this.filterIsSingletonBoolean = this.getFilter().getCardinality() == 16384 && this.getFilter().getItemType().equals(BuiltInAtomicType.BOOLEAN);
        this.filterIsIndependent = (this.getFilter().getDependencies() & 0x1E) == 0;
        ExpressionTool.resetStaticProperties(this);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Sequence sequence;
        Expression result;
        Expression subsequence;
        boolean contextIsDoc;
        Expression f;
        int isIndexable;
        ItemType filterType;
        Configuration config = this.getConfiguration();
        Optimizer opt = config.obtainOptimizer();
        boolean debug = config.getBooleanProperty("http://saxon.sf.net/feature/trace-optimizer-decisions");
        TypeHierarchy th = config.getTypeHierarchy();
        this.getLhs().optimize(visitor, contextItemType);
        this.getBase().setFiltered(true);
        ContextItemStaticInfo baseItemType = new ContextItemStaticInfo(this.getBase().getItemType(), false, this.getBase());
        this.getRhs().optimize(visitor, baseItemType);
        Expression filter2 = ExpressionTool.unsortedIfHomogeneous(this.getFilter(), visitor.isOptimizeForStreaming());
        if (filter2 != this.getFilter()) {
            this.setFilter(filter2);
        }
        if (this.getFilter() instanceof IsLastExpression && ((IsLastExpression)this.getFilter()).getCondition() && this.getBase() instanceof AxisExpression && ((AxisExpression)this.getBase()).getAxis() == 3) {
            NodeTest test = ((AxisExpression)this.getBase()).getNodeTest();
            AxisExpression fs = new AxisExpression(7, test);
            this.setFilter(SystemFunction.makeCall("empty", this.getRetainedStaticContext(), fs));
        }
        if (!th.isSubType(filterType = this.getFilter().getItemType(), BuiltInAtomicType.BOOLEAN) && th.relationship(filterType, NumericType.getInstance()) == 4) {
            Expression f2 = SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getFilter());
            this.setFilter(f2.optimize(visitor, baseItemType));
        }
        if (this.getFilter() instanceof Literal && ((Literal)this.getFilter()).getValue() instanceof BooleanValue) {
            if (((BooleanValue)((Literal)this.getFilter()).getValue()).getBooleanValue()) {
                if (debug) {
                    opt.trace("Redundant filter removed", this.getBase());
                }
                return this.getBase();
            }
            Literal result2 = Literal.makeEmptySequence();
            ExpressionTool.copyLocationInfo(this, result2);
            if (debug) {
                opt.trace("Filter expression eliminated because predicate is always false", result2);
            }
            return result2;
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.getFilter(), th);
        boolean bl = this.filterIsSingletonBoolean = this.getFilter().getCardinality() == 16384 && this.getFilter().getItemType().equals(BuiltInAtomicType.BOOLEAN);
        if (!this.filterIsPositional && !visitor.isOptimizeForStreaming() && (isIndexable = opt.isIndexableFilter(this.getFilter())) != 0 && (f = opt.tryIndexedFilter(this, visitor, isIndexable > 0, contextIsDoc = contextItemType != null && contextItemType.getItemType() != ErrorType.getInstance() && th.isSubType(contextItemType.getItemType(), NodeKindTest.DOCUMENT))) != this) {
            return f.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        if (this.filterIsPositional && this.getFilter() instanceof BooleanExpression && ((BooleanExpression)this.getFilter()).operator == 10) {
            Expression p1;
            BooleanExpression bf = (BooleanExpression)this.getFilter();
            if (FilterExpression.isExplicitlyPositional(bf.getLhsExpression()) && !FilterExpression.isExplicitlyPositional(bf.getRhsExpression())) {
                Expression p0 = FilterExpression.forceToBoolean(bf.getLhsExpression());
                p1 = FilterExpression.forceToBoolean(bf.getRhsExpression());
                FilterExpression f1 = new FilterExpression(this.getBase(), p0);
                ExpressionTool.copyLocationInfo(this, f1);
                FilterExpression f2 = new FilterExpression(f1, p1);
                ExpressionTool.copyLocationInfo(this, f2);
                if (debug) {
                    opt.trace("Composite filter replaced by nested filter expressions", f2);
                }
                return f2.optimize(visitor, contextItemType);
            }
            if (FilterExpression.isExplicitlyPositional(bf.getRhsExpression()) && !FilterExpression.isExplicitlyPositional(bf.getLhsExpression())) {
                Expression p0 = FilterExpression.forceToBoolean(bf.getLhsExpression());
                p1 = FilterExpression.forceToBoolean(bf.getRhsExpression());
                FilterExpression f1 = new FilterExpression(this.getBase(), p1);
                ExpressionTool.copyLocationInfo(this, f1);
                FilterExpression f2 = new FilterExpression(f1, p0);
                ExpressionTool.copyLocationInfo(this, f2);
                if (debug) {
                    opt.trace("Composite filter replaced by nested filter expressions", f2);
                }
                return f2.optimize(visitor, contextItemType);
            }
        }
        if (this.getFilter() instanceof IsLastExpression && ((IsLastExpression)this.getFilter()).getCondition()) {
            if (this.getBase() instanceof Literal) {
                this.setFilter(Literal.makeLiteral(new Int64Value(((Literal)this.getBase()).getValue().getLength())));
            } else {
                return new LastItemExpression(this.getBase());
            }
        }
        if ((subsequence = this.tryToRewritePositionalFilter(visitor)) != null) {
            if (debug) {
                subsequence.setRetainedStaticContext(this.getRetainedStaticContext());
                opt.trace("Rewrote Filter Expression as:", subsequence);
            }
            ExpressionTool.copyLocationInfo(this, subsequence);
            return subsequence.simplify().typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        if (!this.filterIsPositional && this.getLhsExpression() instanceof FilterExpression && !((FilterExpression)this.getLhsExpression()).isFilterIsPositional()) {
            Expression base = ((FilterExpression)this.getLhsExpression()).getLhsExpression();
            Expression predicate1 = ((FilterExpression)this.getLhsExpression()).getRhsExpression();
            Expression predicate2 = this.getRhsExpression();
            if (predicate1.getCost() > 2 * predicate2.getCost()) {
                FilterExpression fe1 = new FilterExpression(base, predicate2);
                FilterExpression fe2 = new FilterExpression(fe1, predicate1);
                ExpressionTool.copyLocationInfo(this, fe2);
                return fe2.optimize(visitor, contextItemType);
            }
        }
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 10;
        offer.promoteDocumentDependent = (this.getBase().getSpecialProperties() & 0x10000) != 0;
        offer.containingExpression = this;
        filter2 = this.doPromotion(this.getFilter(), offer);
        if (filter2 != this.getFilter()) {
            this.setFilter(filter2);
            this.adoptChildExpression(filter2);
            ExpressionTool.resetStaticProperties(filter2);
        }
        if (offer.containingExpression instanceof LetExpression) {
            if (debug) {
                opt.trace("Subexpression extracted from filter because independent of context", offer.containingExpression);
            }
            ExpressionTool.resetStaticProperties(filter2);
            offer.containingExpression = offer.containingExpression.optimize(visitor, contextItemType);
        }
        if ((result = offer.containingExpression) instanceof FilterExpression && (sequence = ((FilterExpression)result).tryEarlyEvaluation(visitor)) != null) {
            GroundedValue value = SequenceTool.toGroundedValue(sequence);
            return Literal.makeLiteral(value);
        }
        return result;
    }

    public int getCost() {
        return this.getLhsExpression().getCost() + 5 * this.getRhsExpression().getCost();
    }

    public int getImplementationMethod() {
        return 2;
    }

    public IntegerValue[] getIntegerBounds() {
        return this.getBase().getIntegerBounds();
    }

    private Sequence tryEarlyEvaluation(ExpressionVisitor visitor) throws XPathException {
        try {
            if (this.getBase() instanceof Literal && !ExpressionTool.refersToVariableOrFunction(this.getFilter()) && (this.getFilter().getDependencies() & 0xFFFFFFE1) == 0) {
                XPathContext context = visitor.getStaticContext().makeEarlyEvaluationContext();
                return SequenceExtent.makeSequenceExtent(this.iterate(context));
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.getBase().addToPathMap(pathMap, pathMapNodeSet);
        this.getFilter().addToPathMap(pathMap, target);
        return target;
    }

    private static Expression forceToBoolean(Expression in) throws XPathException {
        if (in.getItemType().getPrimitiveType() == 514) {
            return in;
        }
        return SystemFunction.makeCall("boolean", in.getRetainedStaticContext(), in);
    }

    private Expression tryToRewritePositionalFilter(ExpressionVisitor visitor) throws XPathException {
        if (visitor.isOptimizeForStreaming()) {
            return null;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (this.getFilter() instanceof Literal) {
            GroundedValue val = ((Literal)this.getFilter()).getValue();
            if (val instanceof NumericValue) {
                if (((NumericValue)val).isWholeNumber()) {
                    long lvalue = ((NumericValue)val).longValue();
                    if (lvalue <= 0L || lvalue >= Integer.MAX_VALUE) {
                        return Literal.makeEmptySequence();
                    }
                    if (lvalue == 1L) {
                        return FirstItemExpression.makeFirstItemExpression(this.getBase());
                    }
                    return new SubscriptExpression(this.getBase(), this.getFilter());
                }
                return Literal.makeEmptySequence();
            }
            return ExpressionTool.effectiveBooleanValue(val.iterate()) ? this.getBase() : Literal.makeEmptySequence();
        }
        if (th.isSubType(this.getFilter().getItemType(), NumericType.getInstance()) && !Cardinality.allowsMany(this.getFilter().getCardinality()) && (this.getFilter().getDependencies() & 0x1E) == 0) {
            return new SubscriptExpression(this.getBase(), this.getFilter());
        }
        if (this.getFilter() instanceof ComparisonExpression) {
            Expression comparand;
            VendorFunctionLibrary lib = this.getConfiguration().getVendorFunctionLibrary();
            StaticContext env = visitor.getStaticContext();
            Expression lhs = ((ComparisonExpression)((Object)this.getFilter())).getLhsExpression();
            Expression rhs = ((ComparisonExpression)((Object)this.getFilter())).getRhsExpression();
            int operator = ((ComparisonExpression)((Object)this.getFilter())).getSingletonOperator();
            if (lhs.isCallOn(PositionAndLast.Position.class) && th.isSubType(rhs.getItemType(), NumericType.getInstance())) {
                comparand = rhs;
            } else if (rhs.isCallOn(PositionAndLast.Position.class) && th.isSubType(lhs.getItemType(), NumericType.getInstance())) {
                comparand = lhs;
                operator = Token.inverse(operator);
            } else {
                return null;
            }
            if (ExpressionTool.dependsOnFocus(comparand)) {
                return null;
            }
            int card = comparand.getCardinality();
            if (Cardinality.allowsMany(card)) {
                return null;
            }
            if (Cardinality.allowsZero(card)) {
                LetExpression let = new LetExpression();
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(), card));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                comparand = new LocalVariableReference(let);
                LocalVariableReference existsArg = new LocalVariableReference(let);
                Expression exists = SystemFunction.makeCall("exists", this.getRetainedStaticContext(), existsArg);
                Expression rewrite = FilterExpression.tryToRewritePositionalFilterSupport(this.getBase(), comparand, operator, th, lib, env);
                if (rewrite == null) {
                    return this;
                }
                Expression choice = Choose.makeConditional(exists, rewrite);
                let.setAction(choice);
                return let;
            }
            return FilterExpression.tryToRewritePositionalFilterSupport(this.getBase(), comparand, operator, th, lib, env);
        }
        if (this.getFilter() instanceof IntegerRangeTest) {
            Expression val = ((IntegerRangeTest)this.getFilter()).getValue();
            if (!val.isCallOn(PositionAndLast.class)) {
                return null;
            }
            Expression min = ((IntegerRangeTest)this.getFilter()).getMin();
            Expression max = ((IntegerRangeTest)this.getFilter()).getMax();
            if (ExpressionTool.dependsOnFocus(min)) {
                return null;
            }
            if (ExpressionTool.dependsOnFocus(max)) {
                if (max.isCallOn(PositionAndLast.Last.class)) {
                    return SystemFunction.makeCall("subsequence", this.getRetainedStaticContext(), this.getBase(), min);
                }
                return null;
            }
            LetExpression let = new LetExpression();
            let.setRequiredType(SequenceType.SINGLE_INTEGER);
            let.setVariableQName(new StructuredQName("nn", "http://saxon.sf.net/", "nn" + let.hashCode()));
            let.setSequence(min);
            min = new LocalVariableReference(let);
            LocalVariableReference min2 = new LocalVariableReference(let);
            ArithmeticExpression minMinusOne = new ArithmeticExpression(min2, 16, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)));
            ArithmeticExpression length = new ArithmeticExpression(max, 16, minMinusOne);
            Expression subs = SystemFunction.makeCall("subsequence", this.getRetainedStaticContext(), this.getBase(), min, length);
            let.setAction(subs);
            return let;
        }
        return null;
    }

    private static Expression tryToRewritePositionalFilterSupport(Expression start, Expression comparand, int operator, TypeHierarchy th, VendorFunctionLibrary lib, StaticContext env) throws XPathException {
        if (th.isSubType(comparand.getItemType(), BuiltInAtomicType.INTEGER)) {
            switch (operator) {
                case 50: {
                    if (Literal.isConstantOne(comparand)) {
                        return FirstItemExpression.makeFirstItemExpression(start);
                    }
                    if (comparand instanceof Literal && ((IntegerValue)((Literal)comparand).getValue()).asBigInteger().compareTo(BigInteger.ZERO) <= 0) {
                        return Literal.makeEmptySequence();
                    }
                    return new SubscriptExpression(start, comparand);
                }
                case 53: {
                    Expression[] args = new Expression[3];
                    args[0] = start;
                    args[1] = Literal.makeLiteral(Int64Value.makeIntegerValue(1L));
                    if (Literal.isAtomic(comparand)) {
                        long n = ((NumericValue)((Literal)comparand).getValue()).longValue();
                        args[2] = Literal.makeLiteral(Int64Value.makeIntegerValue(n - 1L));
                    } else {
                        ArithmeticExpression decrement = new ArithmeticExpression(comparand, 16, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)));
                        decrement.setCalculator(Calculator.getCalculator(533, 533, 1, true));
                        args[2] = decrement;
                    }
                    return SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), args);
                }
                case 55: {
                    Expression[] args = new Expression[]{start, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)), comparand};
                    return SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), args);
                }
                case 51: {
                    return SystemFunction.makeCall("remove", start.getRetainedStaticContext(), start, comparand);
                }
                case 52: {
                    Expression[] args = new Expression[2];
                    args[0] = start;
                    if (Literal.isAtomic(comparand)) {
                        long n = ((NumericValue)((Literal)comparand).getValue()).longValue();
                        args[1] = Literal.makeLiteral(Int64Value.makeIntegerValue(n + 1L));
                    } else {
                        args[1] = new ArithmeticExpression(comparand, 15, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)));
                    }
                    return SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), args);
                }
                case 54: {
                    return SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), start, comparand);
                }
            }
            throw new IllegalArgumentException("operator");
        }
        switch (operator) {
            case 50: {
                return new SubscriptExpression(start, comparand);
            }
            case 53: {
                LetExpression let = new LetExpression();
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(), 16384));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                LocalVariableReference isWholeArg = new LocalVariableReference(let);
                LocalVariableReference arithArg = new LocalVariableReference(let);
                LocalVariableReference floorArg = new LocalVariableReference(let);
                Expression isWhole = lib.makeSaxonFunction("is-whole-number", new Expression[]{isWholeArg}, env);
                ArithmeticExpression minusOne = new ArithmeticExpression(arithArg, 16, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)));
                Expression floor = SystemFunction.makeCall("floor", start.getRetainedStaticContext(), floorArg);
                Expression choice = Choose.makeConditional(isWhole, minusOne, floor);
                Expression subs = SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), start, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)), choice);
                let.setAction(subs);
                return let;
            }
            case 55: {
                Expression floor = SystemFunction.makeCall("floor", start.getRetainedStaticContext(), comparand);
                return SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), start, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)), floor);
            }
            case 51: {
                LetExpression let = new LetExpression();
                ExpressionTool.copyLocationInfo(start, let);
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(), 16384));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                LocalVariableReference isWholeArg = new LocalVariableReference(let);
                LocalVariableReference castArg = new LocalVariableReference(let);
                Expression isWhole = lib.makeSaxonFunction("is-whole-number", new Expression[]{isWholeArg}, env);
                ExpressionTool.copyLocationInfo(start, isWhole);
                CastExpression cast = new CastExpression(castArg, BuiltInAtomicType.INTEGER, false);
                ExpressionTool.copyLocationInfo(start, cast);
                Expression choice = Choose.makeConditional(isWhole, cast, Literal.makeLiteral(Int64Value.makeIntegerValue(0L)));
                Expression rem = SystemFunction.makeCall("remove", start.getRetainedStaticContext(), start, choice);
                let.setAction(rem);
                return let;
            }
            case 52: {
                LetExpression let = new LetExpression();
                let.setRequiredType(SequenceType.makeSequenceType(comparand.getItemType(), 16384));
                let.setVariableQName(new StructuredQName("pp", "http://saxon.sf.net/", "pp" + let.hashCode()));
                let.setSequence(comparand);
                LocalVariableReference isWholeArg = new LocalVariableReference(let);
                LocalVariableReference arithArg = new LocalVariableReference(let);
                LocalVariableReference ceilingArg = new LocalVariableReference(let);
                Expression isWhole = lib.makeSaxonFunction("is-whole-number", new Expression[]{isWholeArg}, env);
                ArithmeticExpression plusOne = new ArithmeticExpression(arithArg, 15, Literal.makeLiteral(Int64Value.makeIntegerValue(1L)));
                Expression ceiling = SystemFunction.makeCall("ceiling", start.getRetainedStaticContext(), ceilingArg);
                Expression choice = Choose.makeConditional(isWhole, plusOne, ceiling);
                Expression subs = SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), start, choice);
                let.setAction(subs);
                return let;
            }
            case 54: {
                Expression ceiling = SystemFunction.makeCall("ceiling", start.getRetainedStaticContext(), comparand);
                return SystemFunction.makeCall("subsequence", start.getRetainedStaticContext(), start, ceiling);
            }
        }
        throw new IllegalArgumentException("operator");
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        if (offer.action == 11 && this.getBase() instanceof FilterExpression) {
            TypeHierarchy th = offer.getOptimizer().getConfiguration().getTypeHierarchy();
            FilterExpression newfe = this.promoteIndependentPredicates(offer.bindingList, offer.getOptimizer(), th);
            if (newfe != this) {
                return newfe.promote(offer);
            }
        }
        this.setBase(this.doPromotion(this.getBase(), offer));
        return this;
    }

    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        if (!this.filterIsPositional) {
            this.setBase(this.getBase().unordered(retainAllNodes, forStreaming));
        }
        return this;
    }

    private FilterExpression promoteIndependentPredicates(Binding[] bindings, Optimizer opt, TypeHierarchy th) {
        if (!ExpressionTool.dependsOnVariable(this.getBase(), bindings)) {
            return this;
        }
        if (this.isPositional(th)) {
            return this;
        }
        if (this.getBase() instanceof FilterExpression) {
            FilterExpression fe = (FilterExpression)this.getBase();
            if (fe.isPositional(th)) {
                return this;
            }
            if (!ExpressionTool.dependsOnVariable(fe.getFilter(), bindings)) {
                return this;
            }
            if (!ExpressionTool.dependsOnVariable(this.getFilter(), bindings)) {
                FilterExpression result = new FilterExpression(new FilterExpression(fe.getBase(), this.getFilter()).promoteIndependentPredicates(bindings, opt, th), fe.getFilter());
                opt.trace("Reordered filter predicates:", result);
                return result;
            }
        }
        return this;
    }

    public static boolean isPositionalFilter(Expression exp, TypeHierarchy th) {
        ItemType type = exp.getItemType();
        if (type.equals(BuiltInAtomicType.BOOLEAN)) {
            return FilterExpression.isExplicitlyPositional(exp);
        }
        return type.equals(BuiltInAtomicType.ANY_ATOMIC) || type instanceof AnyItemType || type.equals(BuiltInAtomicType.INTEGER) || type.equals(NumericType.getInstance()) || th.isSubType(type, NumericType.getInstance()) || FilterExpression.isExplicitlyPositional(exp);
    }

    private static boolean isExplicitlyPositional(Expression exp) {
        return (exp.getDependencies() & 0xC) != 0;
    }

    public int computeCardinality() {
        if (this.getFilter() instanceof Literal && ((Literal)this.getFilter()).getValue() instanceof NumericValue) {
            if (((NumericValue)((Literal)this.getFilter()).getValue()).compareTo(1L) == 0 && !Cardinality.allowsZero(this.getBase().getCardinality())) {
                return 16384;
            }
            return 24576;
        }
        if (this.filterIsIndependent) {
            ItemType filterType = this.getFilter().getItemType().getPrimitiveItemType();
            if (filterType == BuiltInAtomicType.INTEGER || filterType == BuiltInAtomicType.DOUBLE || filterType == BuiltInAtomicType.DECIMAL || filterType == BuiltInAtomicType.FLOAT) {
                return 24576;
            }
            if (this.getFilter() instanceof ArithmeticExpression || this.getFilter() instanceof ArithmeticExpression10) {
                return 24576;
            }
        }
        if (this.getFilter() instanceof IsLastExpression && ((IsLastExpression)this.getFilter()).getCondition()) {
            return this.getBase().getCardinality() & 0xFFFF7FFF;
        }
        if (!Cardinality.allowsMany(this.getBase().getCardinality())) {
            return 24576;
        }
        return 57344;
    }

    public int computeSpecialProperties() {
        return this.getBase().getSpecialProperties();
    }

    public boolean equals(Object other) {
        if (other instanceof FilterExpression) {
            FilterExpression f = (FilterExpression)other;
            return this.getBase().equals(f.getBase()) && this.getFilter().equals(f.getFilter());
        }
        return false;
    }

    public int hashCode() {
        return "FilterExpression".hashCode() + this.getBase().hashCode() + this.getFilter().hashCode();
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        Expression base = this.getSelectExpression();
        Expression filter = this.getFilter();
        TypeHierarchy th = config.getTypeHierarchy();
        Pattern basePattern = base.toPattern(config, is30);
        if (!this.isPositional(th)) {
            return new PatternWithPredicate(basePattern, filter);
        }
        if (basePattern instanceof NodeTestPattern && basePattern.getItemType() instanceof NodeTest && this.filterIsPositional && base instanceof AxisExpression && ((AxisExpression)base).getAxis() == 3 && (filter.getDependencies() & 8) == 0) {
            if (filter instanceof Literal && ((Literal)filter).getValue() instanceof IntegerValue) {
                return new SimplePositionalPattern((NodeTest)basePattern.getItemType(), (int)((IntegerValue)((Literal)filter).getValue()).longValue());
            }
            return new GeneralPositionalPattern((NodeTest)basePattern.getItemType(), filter);
        }
        if (base.getItemType() instanceof NodeTest) {
            return new GeneralNodePattern(this, (NodeTest)base.getItemType());
        }
        throw new XPathException("The filtered expression in an XSLT 2.0 pattern must be a simple step");
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator baseIter;
        if (this.filterIsIndependent) {
            try {
                SequenceIterator it = this.getFilter().iterate(context);
                Item first = it.next();
                if (first == null) {
                    return EmptyIterator.emptyIterator();
                }
                if (first instanceof NumericValue) {
                    if (it.next() == null) {
                        NumericValue subscript = (NumericValue)first;
                        if (subscript.isWholeNumber() && subscript.signum() > 0 && subscript.longValue() < Integer.MAX_VALUE) {
                            int pos = (int)subscript.longValue();
                            if (this.getBase() instanceof VariableReference) {
                                Sequence baseVal = ((VariableReference)this.getBase()).evaluateVariable(context);
                                if (baseVal instanceof MemoClosure) {
                                    Item m = ((MemoClosure)baseVal).itemAt(pos - 1);
                                    return m == null ? EmptyIterator.emptyIterator() : m.iterate();
                                }
                                Item m = SequenceTool.toGroundedValue(baseVal).itemAt(pos - 1);
                                return m == null ? EmptyIterator.emptyIterator() : m.iterate();
                            }
                            if (this.getBase() instanceof Literal) {
                                Item i = ((Literal)this.getBase()).getValue().itemAt(pos - 1);
                                return i == null ? EmptyIterator.getInstance() : i.iterate();
                            }
                            SequenceIterator baseIter2 = this.getBase().iterate(context);
                            return SubsequenceIterator.make(baseIter2, pos, pos);
                        }
                        return EmptyIterator.emptyIterator();
                    }
                } else {
                    boolean ebv = false;
                    if (first instanceof NodeInfo) {
                        ebv = true;
                    } else if (first instanceof BooleanValue) {
                        ebv = ((BooleanValue)first).getBooleanValue();
                        if (it.next() != null) {
                            ExpressionTool.ebvError("sequence of two or more items starting with a boolean value");
                        }
                    } else if (first instanceof StringValue) {
                        boolean bl = ebv = !((StringValue)first).isZeroLength();
                        if (it.next() != null) {
                            ExpressionTool.ebvError("sequence of two or more items starting with a boolean value");
                        }
                    } else {
                        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, or string");
                    }
                    if (ebv) {
                        return this.getBase().iterate(context);
                    }
                    return EmptyIterator.emptyIterator();
                }
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
        }
        if ((baseIter = this.getBase().iterate(context)) instanceof EmptyIterator) {
            return baseIter;
        }
        if (this.filterIsPositional && !this.filterIsSingletonBoolean) {
            return new FilterIterator(baseIter, this.getFilter(), context);
        }
        return new FilterIterator.NonNumeric(baseIter, this.getFilter(), context);
    }

    public Expression copy(RebindingMap rebindings) {
        FilterExpression fe = new FilterExpression(this.getBase().copy(rebindings), this.getFilter().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, fe);
        fe.filterIsIndependent = this.filterIsIndependent;
        fe.filterIsPositional = this.filterIsPositional;
        fe.filterIsSingletonBoolean = this.filterIsSingletonBoolean;
        return fe;
    }

    public String toString() {
        return ExpressionTool.parenthesize(this.getBase()) + "[" + this.getFilter().toString() + "]";
    }

    public String toShortString() {
        return this.getBase().toShortString() + "[" + this.getFilter().toShortString() + "]";
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("filter", this);
        String flags = "";
        if (this.filterIsIndependent) {
            flags = flags + "i";
        }
        if (this.filterIsPositional) {
            flags = flags + "p";
        }
        if (this.filterIsSingletonBoolean) {
            flags = flags + "b";
        }
        out.emitAttribute("flags", flags);
        this.getBase().export(out);
        this.getFilter().export(out);
        out.endElement();
    }

    public void setFlags(String flags) {
        this.filterIsIndependent = flags.contains("i");
        this.filterIsPositional = flags.contains("p");
        this.filterIsSingletonBoolean = flags.contains("b");
    }
}

