/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jxls.reader.XLSBlockReader;
import net.sf.jxls.reader.XLSReadStatus;
import net.sf.jxls.reader.XLSRowCursorImpl;
import net.sf.jxls.reader.XLSSheetReader;
import org.apache.poi.ss.usermodel.Sheet;

public class XLSSheetReaderImpl
implements XLSSheetReader {
    List blockReaders = new ArrayList();
    String sheetName;
    int sheetIdx = -1;
    XLSReadStatus readStatus = new XLSReadStatus();

    @Override
    public XLSReadStatus read(Sheet sheet, Map beans) {
        this.readStatus.clear();
        XLSRowCursorImpl cursor = new XLSRowCursorImpl(this.sheetName, sheet);
        for (int i = 0; i < this.blockReaders.size(); ++i) {
            XLSBlockReader blockReader = (XLSBlockReader)this.blockReaders.get(i);
            this.readStatus.mergeReadStatus(blockReader.read(cursor, beans));
            cursor.moveForward();
        }
        return this.readStatus;
    }

    public String getSheetNameBySheetIdx(Sheet sheet, int idx) {
        Sheet sheetAtIdx = sheet.getWorkbook().getSheetAt(idx);
        return sheetAtIdx.getSheetName();
    }

    @Override
    public List getBlockReaders() {
        return this.blockReaders;
    }

    @Override
    public void setBlockReaders(List blockReaders) {
        this.blockReaders = blockReaders;
    }

    @Override
    public void addBlockReader(XLSBlockReader blockReader) {
        this.blockReaders.add(blockReader);
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public int getSheetIdx() {
        return this.sheetIdx;
    }

    @Override
    public void setSheetIdx(int sheetIdx) {
        this.sheetIdx = sheetIdx;
    }
}

