/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jxls.reader.BaseBlockReader;
import net.sf.jxls.reader.ExpressionCollectionParser;
import net.sf.jxls.reader.ReaderConfig;
import net.sf.jxls.reader.SectionCheck;
import net.sf.jxls.reader.XLSBlockReader;
import net.sf.jxls.reader.XLSDataReadException;
import net.sf.jxls.reader.XLSLoopBlockReader;
import net.sf.jxls.reader.XLSReadMessage;
import net.sf.jxls.reader.XLSReadStatus;
import net.sf.jxls.reader.XLSRowCursor;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XLSForEachBlockReaderImpl
extends BaseBlockReader
implements XLSLoopBlockReader {
    protected final Log log = LogFactory.getLog(this.getClass());
    String items;
    String var;
    Class varType;
    List innerBlockReaders = new ArrayList();
    SectionCheck loopBreakCheck;

    public XLSForEachBlockReaderImpl() {
    }

    public XLSForEachBlockReaderImpl(int startRow, int endRow, String items, String var, Class varType) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.items = items;
        this.var = var;
        this.varType = varType;
    }

    @Override
    public XLSReadStatus read(XLSRowCursor cursor, Map beans) {
        this.readStatus.clear();
        MapContext context = new MapContext(beans);
        ExpressionCollectionParser parser = new ExpressionCollectionParser((JexlContext)context, this.items + ";", true);
        Collection itemsCollection = parser.getCollection();
        while (!this.loopBreakCheck.isCheckSuccessful(cursor)) {
            this.createNewCollectionItem(itemsCollection, beans);
            this.readInnerBlocks(cursor, beans);
        }
        cursor.moveBackward();
        return this.readStatus;
    }

    private void createNewCollectionItem(Collection itemsCollection, Map beans) {
        Object obj;
        block3: {
            obj = null;
            try {
                obj = this.varType.newInstance();
            }
            catch (Exception e) {
                String message = "Can't create a new collection item for " + this.items + ". varType = " + this.varType.getName();
                this.readStatus.addMessage(new XLSReadMessage(message));
                if (!ReaderConfig.getInstance().isSkipErrors()) {
                    this.readStatus.setStatusOK(false);
                    throw new XLSDataReadException(message, this.readStatus);
                }
                if (!this.log.isWarnEnabled()) break block3;
                this.log.warn((Object)message);
            }
        }
        itemsCollection.add(obj);
        beans.put(this.var, obj);
    }

    private void readInnerBlocks(XLSRowCursor cursor, Map beans) {
        for (int i = 0; i < this.innerBlockReaders.size(); ++i) {
            XLSBlockReader xlsBlockReader = (XLSBlockReader)this.innerBlockReaders.get(i);
            this.readStatus.mergeReadStatus(xlsBlockReader.read(cursor, beans));
            cursor.moveForward();
        }
    }

    @Override
    public void addBlockReader(XLSBlockReader reader) {
        this.innerBlockReaders.add(reader);
    }

    @Override
    public List getBlockReaders() {
        return this.innerBlockReaders;
    }

    @Override
    public SectionCheck getLoopBreakCondition() {
        return this.loopBreakCheck;
    }

    @Override
    public void setLoopBreakCondition(SectionCheck sectionCheck) {
        this.loopBreakCheck = sectionCheck;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarType(Class varType) {
        this.varType = varType;
    }

    public String getItems() {
        return this.items;
    }

    public String getVar() {
        return this.var;
    }

    public Class getVarType() {
        return this.varType;
    }
}

