/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import net.thucydides.core.steps.service.CleanupMethodAnnotationProvider;

public class CleanupMethodLocator {
    private final List<String> cleanupMethodsAnnotations = new ArrayList<String>();
    private final List<String> DEFAULT_CLEANUP_PACKAGES_TO_SKIP = Arrays.asList("java.lang", "net.serenitybdd.core", "net.thucydides", "org.junit", "org.openqa.selenium");

    public CleanupMethodLocator() {
        ServiceLoader<CleanupMethodAnnotationProvider> cleanupMethodAnnotationProviders = ServiceLoader.load(CleanupMethodAnnotationProvider.class);
        for (CleanupMethodAnnotationProvider cleanupMethodAnnotationProvider : cleanupMethodAnnotationProviders) {
            this.cleanupMethodsAnnotations.addAll(cleanupMethodAnnotationProvider.getCleanupMethodAnnotations());
        }
    }

    public boolean currentMethodWasCalledFromACleanupMethod() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTrace).anyMatch(this::isAnnotatedWithAFixtureMethod);
    }

    private boolean isAnnotatedWithAFixtureMethod(StackTraceElement stackTraceElement) {
        try {
            if (this.inPackageToSkip(stackTraceElement.getClassName())) {
                return false;
            }
            Optional<Method> fixtureMethod = Arrays.stream(CleanupMethodLocator.forName(stackTraceElement.getClassName()).getMethods()).filter(method -> method.getName().equals(stackTraceElement.getMethodName())).findFirst();
            return fixtureMethod.map(method -> Arrays.stream(method.getAnnotations()).anyMatch(annotation -> this.isAnAfterAnnotation(annotation.annotationType().getSimpleName()) || this.cleanupMethodsAnnotations.contains(annotation.toString()))).orElse(false);
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private boolean inPackageToSkip(String className) {
        return this.DEFAULT_CLEANUP_PACKAGES_TO_SKIP.stream().anyMatch(className::startsWith);
    }

    private static Class<?> forName(String className) throws ClassNotFoundException {
        return CleanupMethodLocator.forName(className, null);
    }

    private static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return Class.forName(className, false, classLoader);
                }
            }
            catch (ClassNotFoundException e) {
                classLoader = null;
            }
        }
        if (classLoader != null) {
            return Class.forName(className, false, classLoader);
        }
        return Class.forName(className);
    }

    private boolean isAnAfterAnnotation(String annotationName) {
        return annotationName.startsWith("After");
    }
}

