/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.model.matchers.BeanMatcher;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class HtmlTable {
    private final WebElement tableElement;
    private List<String> headings;
    private CellReaderStrategy cellReaderStrategy;

    public HtmlTable(WebElement tableElement) {
        this.tableElement = tableElement;
        this.headings = null;
        this.cellReaderStrategy = CellReaderStrategy.GET_TEXT;
    }

    public HtmlTable(WebElement tableElement, List<String> headings) {
        this.tableElement = tableElement;
        this.headings = headings;
        this.cellReaderStrategy = CellReaderStrategy.GET_TEXT;
    }

    public HtmlTable readingCellContentsWith(CellReaderStrategy cellReaderStrategy) {
        this.cellReaderStrategy = cellReaderStrategy;
        return this;
    }

    public static HtmlTable inTable(WebElement table) {
        return new HtmlTable(table);
    }

    public List<Map<Object, String>> getRows() {
        ArrayList<Map<Object, String>> results = new ArrayList<Map<Object, String>>();
        List<String> headings = this.getHeadings();
        List<WebElement> rows = this.getRowElementsFor(headings);
        for (WebElement row : rows) {
            List<WebElement> cells = this.cellsIn(row);
            if (!this.enoughCellsFor(headings).in(cells)) continue;
            results.add(this.rowDataFrom(cells, headings));
        }
        return results;
    }

    public WebElement findFirstRowWhere(BeanMatcher ... matchers) {
        List<WebElement> rows = this.getRowElementsWhere(matchers);
        if (rows.isEmpty()) {
            throw new AssertionError((Object)("Expecting a table with at least one row where: " + Arrays.deepToString(matchers)));
        }
        return rows.get(0);
    }

    public boolean containsRowElementsWhere(BeanMatcher ... matchers) {
        List<WebElement> rows = this.getRowElementsWhere(matchers);
        return !rows.isEmpty();
    }

    public void shouldHaveRowElementsWhere(BeanMatcher ... matchers) {
        List<WebElement> rows = this.getRowElementsWhere(matchers);
        if (rows.isEmpty()) {
            throw new AssertionError((Object)("Expecting a table with at least one row where: " + Arrays.deepToString(matchers)));
        }
    }

    public void shouldNotHaveRowElementsWhere(BeanMatcher ... matchers) {
        List<WebElement> rows = this.getRowElementsWhere(matchers);
        if (!rows.isEmpty()) {
            throw new AssertionError((Object)("Expecting a table with no rows where: " + Arrays.deepToString(matchers)));
        }
    }

    public static HtmlTableBuilder withColumns(String ... headings) {
        return new HtmlTableBuilder(Arrays.asList(headings));
    }

    private EnoughCellsCheck enoughCellsFor(List<String> headings) {
        return new EnoughCellsCheck(headings);
    }

    public List<String> getHeadings() {
        if (this.headings == null) {
            List thHeadings = this.headingElements().stream().map(this::cellToText).collect(Collectors.toList());
            this.headings = thHeadings.isEmpty() ? this.firstRowElements().stream().map(element -> element.getAttribute("textContent")).collect(Collectors.toList()) : thHeadings;
        }
        return this.headings;
    }

    public List<WebElement> headingElements() {
        return this.tableElement.findElements(By.xpath((String)".//th"));
    }

    public List<WebElement> firstRowElements() {
        return this.tableElement.findElement(By.tagName((String)"tr")).findElements(By.xpath((String)".//td"));
    }

    public List<WebElement> getRowElementsFor(List<String> headings) {
        List<WebElement> rowCandidates = this.tableElement.findElements(By.xpath((String)(".//tr[td][count(td)>=" + headings.size() + "]")));
        rowCandidates = this.stripHeaderRowIfPresent(rowCandidates, headings);
        return rowCandidates;
    }

    public List<WebElement> getRowElements() {
        return this.getRowElementsFor(this.getHeadings());
    }

    private List<WebElement> stripHeaderRowIfPresent(List<WebElement> rowCandidates, List<String> headings) {
        WebElement firstRow;
        if (!rowCandidates.isEmpty() && this.hasMatchingCellValuesIn(firstRow = rowCandidates.get(0), headings)) {
            rowCandidates.remove(0);
        }
        return rowCandidates;
    }

    private boolean hasMatchingCellValuesIn(WebElement firstRow, List<String> headings) {
        List cells = firstRow.findElements(By.xpath((String)"./td"));
        for (int cellIndex = 0; cellIndex < headings.size(); ++cellIndex) {
            if (cells.size() >= cellIndex && this.cellToText((WebElement)cells.get(cellIndex)).equals(headings.get(cellIndex))) continue;
            return false;
        }
        return true;
    }

    public List<WebElement> getRowElementsWhere(BeanMatcher ... matchers) {
        List<WebElement> rowElements = this.getRowElementsFor(this.getHeadings());
        List<Integer> matchingRowIndexes = this.findMatchingIndexesFor(rowElements, matchers);
        ArrayList<WebElement> matchingElements = new ArrayList<WebElement>();
        for (Integer index : matchingRowIndexes) {
            matchingElements.add(rowElements.get(index));
        }
        return matchingElements;
    }

    private List<Integer> findMatchingIndexesFor(List<WebElement> rowElements, BeanMatcher[] matchers) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        List<String> headings = this.getHeadings();
        int index = 0;
        for (WebElement row : rowElements) {
            List<WebElement> cells = this.cellsIn(row);
            Map<Object, String> rowData = this.rowDataFrom(cells, headings);
            if (this.matches(rowData, matchers)) {
                indexes.add(index);
            }
            ++index;
        }
        return indexes;
    }

    private boolean matches(Map<Object, String> rowData, BeanMatcher[] matchers) {
        for (BeanMatcher matcher : matchers) {
            if (matcher.matches(rowData)) continue;
            return false;
        }
        return true;
    }

    private Map<Object, String> rowDataFrom(List<WebElement> cells, List<String> headings) {
        HashMap<Object, String> rowData = new HashMap<Object, String>();
        int column = 0;
        for (String heading : headings) {
            String cell = this.cellValueAt(column++, cells);
            if (!StringUtils.isEmpty((CharSequence)heading)) {
                rowData.put(heading, cell);
            }
            rowData.put(column, cell);
        }
        return rowData;
    }

    private List<WebElement> cellsIn(WebElement row) {
        return row.findElements(By.xpath((String)"./td"));
    }

    private String cellValueAt(int column, List<WebElement> cells) {
        return this.cellToText(cells.get(column));
    }

    private String cellToText(WebElement cell) {
        switch (this.cellReaderStrategy) {
            case GET_TEXT: {
                return cell.getText();
            }
            case TEXT_CONTENT_ATTRIBUTE: {
                return cell.getAttribute("textContent");
            }
            case INNER_TEXT_ATTRIBUTE: {
                return cell.getAttribute("innerText").trim().replaceAll("\\t", " ");
            }
            case OUTER_TEXT_ATTRIBUTE: {
                return cell.getAttribute("outerText").trim().replaceAll("\\t", " ");
            }
        }
        return cell.getText();
    }

    public static List<Map<Object, String>> rowsFrom(WebElement table) {
        return new HtmlTable(table).getRows();
    }

    public static List<WebElement> filterRows(WebElement table, BeanMatcher ... matchers) {
        return new HtmlTable(table).getRowElementsWhere(matchers);
    }

    public List<WebElement> filterRows(BeanMatcher ... matchers) {
        return new HtmlTable(this.tableElement).getRowElementsWhere(matchers);
    }

    public static enum CellReaderStrategy {
        GET_TEXT,
        TEXT_CONTENT_ATTRIBUTE,
        INNER_TEXT_ATTRIBUTE,
        OUTER_TEXT_ATTRIBUTE;

    }

    private static class EnoughCellsCheck {
        private final int minimumNumberOfCells;

        private EnoughCellsCheck(List<String> headings) {
            this.minimumNumberOfCells = headings.size();
        }

        public boolean in(List<WebElement> cells) {
            return cells.size() >= this.minimumNumberOfCells;
        }
    }

    public static class HtmlTableBuilder {
        private final List<String> headings;

        HtmlTableBuilder(List<String> headings) {
            this.headings = headings;
        }

        public List<Map<Object, String>> readRowsFrom(WebElement table) {
            return new HtmlTable(table, this.headings).getRows();
        }

        public HtmlTable inTable(WebElement table) {
            return new HtmlTable(table, this.headings);
        }
    }
}

