/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.WebdriverCollectionStrategy;
import net.thucydides.core.annotations.ElementIsUsable;
import net.thucydides.core.annotations.locators.WaitForWebElements;
import org.openqa.selenium.WebElement;

public class WaitForWebElementCollection {
    static Map<WebdriverCollectionStrategy, WaitForWebElements> COLLECTION_STRATEGY = new HashMap<WebdriverCollectionStrategy, WaitForWebElements>();

    public static WaitForWebElements accordingTo(WebdriverCollectionStrategy collectionStrategy) {
        return COLLECTION_STRATEGY.get((Object)collectionStrategy);
    }

    static {
        COLLECTION_STRATEGY.put(WebdriverCollectionStrategy.Optimistic, elements -> elements != null);
        COLLECTION_STRATEGY.put(WebdriverCollectionStrategy.Pessimistic, elements -> {
            if (elements == null) {
                return false;
            }
            return elements.isEmpty() || ElementIsUsable.forElement((WebElement)elements.get(0));
        });
        COLLECTION_STRATEGY.put(WebdriverCollectionStrategy.Paranoid, elements -> {
            if (elements == null) {
                return false;
            }
            for (WebElement element : elements) {
                if (ElementIsUsable.forElement(element)) continue;
                return false;
            }
            return true;
        });
    }
}

