/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WebdriverCollectionStrategy {
    Optimistic,
    Pessimistic,
    Paranoid;

    private static final Logger logger;
    private static final WebdriverCollectionStrategy DEFAULT_STRATEGY;

    public static WebdriverCollectionStrategy definedIn(EnvironmentVariables environmentVariables) {
        String configuredStrategy = ThucydidesSystemProperty.SERENITY_WEBDRIVER_COLLECTION_LOADING_STRATEGY.from(environmentVariables, "");
        try {
            if (StringUtils.isNotEmpty((CharSequence)configuredStrategy)) {
                return WebdriverCollectionStrategy.valueOf(StringUtils.capitalize((String)StringUtils.lowerCase((String)configuredStrategy)));
            }
        }
        catch (IllegalArgumentException invalidEnumValue) {
            logger.warn("Illegal value for {} - should be one of {}", (Object)ThucydidesSystemProperty.SERENITY_WEBDRIVER_COLLECTION_LOADING_STRATEGY, (Object)WebdriverCollectionStrategy.values());
        }
        return DEFAULT_STRATEGY;
    }

    static {
        logger = LoggerFactory.getLogger(WebdriverCollectionStrategy.class);
        DEFAULT_STRATEGY = Optimistic;
    }
}

