/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.webdriver.servicepools.StopServiceHook;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.service.DriverService;

public class DriverServices {
    private static ThreadLocal<Map<ChromeOptions, ChromeDriverService>> chromeDriverServices = ThreadLocal.withInitial(HashMap::new);

    public static ChromeDriverService getChromeDriverService(ChromeOptions options) {
        ChromeDriverService chromeDriverService = chromeDriverServices.get().get(options);
        if (chromeDriverService != null && chromeDriverService.isRunning()) {
            return chromeDriverService;
        }
        chromeDriverService = ChromeDriverService.createServiceWithConfig((ChromeOptions)options);
        Runtime.getRuntime().addShutdownHook(new StopServiceHook((DriverService)chromeDriverService));
        chromeDriverServices.get().put(options, chromeDriverService);
        return chromeDriverService;
    }
}

