/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography.bluring;

import com.jhlabs.image.BoxBlurFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.serenitybdd.core.photography.AmendedPathBuilder;
import net.serenitybdd.core.photography.PhotoFilter;
import net.serenitybdd.core.photography.ScreenshotNegative;
import net.thucydides.core.screenshots.BlurLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blurer
implements PhotoFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    public Path amendedScreenshotPath(ScreenshotNegative negative) {
        if (negative.getBlurLevel() == BlurLevel.NONE) {
            return negative.getScreenshotPath();
        }
        return this.amendScreenshotPathFor(negative).withPrefix("BLURRED_" + (Object)((Object)negative.getBlurLevel()) + "_");
    }

    private AmendedPathBuilder amendScreenshotPathFor(ScreenshotNegative negative) {
        return new AmendedPathBuilder(negative);
    }

    @Override
    public ScreenshotNegative process(ScreenshotNegative negative) {
        ScreenshotNegative amendedNegative = negative.withScreenshotPath(this.amendedScreenshotPath(negative));
        if (negative.getBlurLevel() == BlurLevel.NONE) {
            return amendedNegative;
        }
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();
             InputStream imageStream = Files.newInputStream(amendedNegative.getTemporaryPath(), new OpenOption[0]);){
            BufferedImage srcImage = ImageIO.read(imageStream);
            BufferedImage destImage = this.deepCopy(srcImage);
            destImage = this.withFilterFor(negative.getBlurLevel()).filter(srcImage, destImage);
            ImageIO.write((RenderedImage)destImage, "png", outStream);
            Files.write(negative.getTemporaryPath(), outStream.toByteArray(), new OpenOption[0]);
        }
        catch (Throwable e) {
            this.LOGGER.warn("Failed to blur screenshot", e);
        }
        return amendedNegative;
    }

    private BoxBlurFilter withFilterFor(BlurLevel blurLevel) {
        BoxBlurFilter boxBlurFilter = new BoxBlurFilter();
        boxBlurFilter.setRadius(blurLevel.getRadius());
        boxBlurFilter.setIterations(3);
        return boxBlurFilter;
    }

    private BufferedImage deepCopy(BufferedImage srcImage) {
        ColorModel cm = srcImage.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = srcImage.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }
}

