/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public final class Util {
    public static final NumberFormat PERCENT_FORMATTER = NumberFormat.getPercentInstance(Locale.US);
    private static final PeriodFormatter TIME_FORMATTER;

    public static String formatDuration(long duration) {
        return TIME_FORMATTER.print((ReadablePeriod)new Period(0L, duration / 1000000L));
    }

    public static String toValidFileName(String value) {
        return value.replaceAll("[^\\d\\w]", "-");
    }

    static {
        PERCENT_FORMATTER.setMinimumFractionDigits(2);
        PERCENT_FORMATTER.setMaximumFractionDigits(2);
        TIME_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendSeparator(" ").appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").appendSeconds().appendSuffix("s").appendSeparator(" ").minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();
    }
}

