/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.support;

import java.util.EnumMap;
import net.masterthought.cucumber.json.support.Status;

public class StatusCounter {
    private EnumMap<Status, Integer> counter = new EnumMap(Status.class);
    private Status finalStatus = Status.PASSED;
    private int size = 0;

    public StatusCounter() {
        for (Status status : Status.values()) {
            this.counter.put(status, 0);
        }
    }

    public void incrementFor(Status status) {
        int statusCounter = this.getValueFor(status) + 1;
        this.counter.put(status, statusCounter);
        ++this.size;
        if (this.finalStatus != Status.FAILED) {
            this.finalStatus = statusCounter == this.size ? status : Status.FAILED;
        }
    }

    public int getValueFor(Status status) {
        return this.counter.get((Object)status);
    }

    public int size() {
        return this.size;
    }

    public Status getFinalStatus() {
        return this.finalStatus;
    }
}

