/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor;

import net.logstash.logback.encoder.com.lmax.disruptor.BatchEventProcessor;
import net.logstash.logback.encoder.com.lmax.disruptor.BatchRewindStrategy;
import net.logstash.logback.encoder.com.lmax.disruptor.DataProvider;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.RewindableEventHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.SequenceBarrier;

public final class BatchEventProcessorBuilder {
    private int maxBatchSize = Integer.MAX_VALUE;

    public BatchEventProcessorBuilder setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }

    public <T> BatchEventProcessor<T> build(DataProvider<T> dataProvider, SequenceBarrier sequenceBarrier, EventHandler<? super T> eventHandler) {
        BatchEventProcessor<T> processor = new BatchEventProcessor<T>(dataProvider, sequenceBarrier, eventHandler, this.maxBatchSize, null);
        eventHandler.setSequenceCallback(processor.getSequence());
        return processor;
    }

    public <T> BatchEventProcessor<T> build(DataProvider<T> dataProvider, SequenceBarrier sequenceBarrier, RewindableEventHandler<? super T> rewindableEventHandler, BatchRewindStrategy batchRewindStrategy) {
        if (null == batchRewindStrategy) {
            throw new NullPointerException("batchRewindStrategy cannot be null when building a BatchEventProcessor");
        }
        return new BatchEventProcessor<T>(dataProvider, sequenceBarrier, rewindableEventHandler, this.maxBatchSize, batchRewindStrategy);
    }
}

