/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.dev.webdav.jaxrs.NullArgumentException;

public final class Utilities {
    public static final <T> T buildInstanceOf(Class<T> cls) {
        if (cls == null) {
            return null;
        }
        if (cls.isEnum()) {
            T[] enumConstants = cls.getEnumConstants();
            return enumConstants.length > 0 ? (T)enumConstants[0] : null;
        }
        return Utilities.newInstance(cls);
    }

    private static final <T> T newInstance(Class<T> cls) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static final <T> T[] append(T[] firstArray, T[] secondArray) {
        T[] expandedArray = Arrays.copyOf(firstArray, firstArray.length + secondArray.length);
        System.arraycopy(secondArray, 0, expandedArray, firstArray.length, secondArray.length);
        return expandedArray;
    }

    public static final <T> T notNull(T t, String name) throws NullArgumentException {
        if (t == null) {
            throw new NullArgumentException(name);
        }
        return t;
    }

    public static final <T> List<T> append(T t, T ... ts) {
        ArrayList<T> result = new ArrayList<T>(1 + ts.length);
        result.add(t);
        result.addAll(Arrays.asList(ts));
        return result;
    }

    public static final <T> T[] array(T ... ts) {
        return ts;
    }

    public static final String toString(Object object, Object ... members) {
        return object.getClass().getSimpleName() + Arrays.toString(members);
    }
}

