/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.dev.webdav.jaxrs.ConstantsAdapter;
import net.java.dev.webdav.jaxrs.xml.elements.ActiveLock;
import net.java.dev.webdav.util.Utilities;

@XmlJavaTypeAdapter(value=Adapter.class)
@XmlRootElement(name="lockdiscovery")
public final class LockDiscovery {
    public static final LockDiscovery LOCKDISCOVERY = new LockDiscovery();
    @XmlElement(name="activelock")
    private final List<ActiveLock> activeLocks;

    @Deprecated
    public LockDiscovery() {
        this.activeLocks = new LinkedList<ActiveLock>();
    }

    public LockDiscovery(ActiveLock ... activeLocks) {
        this.activeLocks = Arrays.asList((Object[])Utilities.notNull(activeLocks, "activeLocks"));
    }

    public final List<ActiveLock> getActiveLocks() {
        return Collections.unmodifiableList(this.activeLocks);
    }

    public final int hashCode() {
        return this.activeLocks.hashCode();
    }

    public final boolean equals(Object other) {
        if (!(other instanceof LockDiscovery)) {
            return false;
        }
        LockDiscovery that = (LockDiscovery)other;
        return this.activeLocks.equals(that.activeLocks);
    }

    public final String toString() {
        return Utilities.toString(this, this.activeLocks);
    }

    protected static final class Adapter
    extends ConstantsAdapter<LockDiscovery> {
        protected Adapter() {
        }

        @Override
        protected final Collection<LockDiscovery> getConstants() {
            return Collections.singleton(LOCKDISCOVERY);
        }
    }
}

